<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Dashboard extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Jakarta");
        $this->load->model('Model_transaksi_dashboard', 'transaksi_dashboard');
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('dashboard');
        $data['title'] = 'Arifah Pulsa';
        $data['halaman'] = 'Dashboard';

        $this->template->load('includes/header', 'dashboard', $data);
    }

    function aksi_panel()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('dashboard');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        //PENDAPATAN
        $pendapatan = $db_arifahpulsa_api->query("SELECT sum(trx_pendapatan_jumlah) as transaksi_pendapatan from tbl_trx_pendapatan");
        if ($pendapatan->num_rows() > 0) {
            foreach ($pendapatan->result() as $row) {
                $data['transaksi_pendapatan'] = number_format($row->transaksi_pendapatan, 0, ',', '.');
            }
        } else {
            $data['transaksi_pendapatan'] = '0';
        }

        //SALDO USER
        $saldo = $db_arifahpulsa_api->query("SELECT sum(mst_saldo_jumlah) as transaksi_saldo from tbl_mst_saldo");
        if ($saldo->num_rows() > 0) {
            foreach ($saldo->result() as $row) {
                $data['transaksi_saldo'] = number_format($row->transaksi_saldo, 0, ',', '.');
            }
        } else {
            $data['transaksi_saldo'] = '0';
        }

        //TRANSAKSI TOTAL
        $transaksi = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as transaksi_jumlah from tbl_trx_transaksi where trx_transaksi_rc in ('1','00','03')");
        if ($transaksi->num_rows() > 0) {
            foreach ($transaksi->result() as $row) {
                $data['transaksi_jumlah'] = number_format($row->transaksi_jumlah, 0, ',', '.');
            }
        } else {
            $data['transaksi_jumlah'] = '0';
        }

        //JUMLAH USER
        $user = $db_arifahpulsa_api->query("SELECT count(mst_user_kode) as transaksi_user from tbl_mst_user");
        if ($user->num_rows() > 0) {
            foreach ($user->result() as $row) {
                $data['transaksi_user'] = number_format($row->transaksi_user, 0, ',', '.');
            }
        } else {
            $data['transaksi_user'] = '0';
        }

        echo json_encode($data);
    }

    function aksi_statistik()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('dashboard');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        //SUKSES
        if (strlen($txt_cari) > 0) {
            $sukses = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_sukses_total,
                                        count(trx_transaksi_kode) as statistik_sukses_jumlah from tbl_trx_transaksi
                                        where
                                        trx_transaksi_kode LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='00'
                                        OR
                                        trx_transaksi_nama LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc='00'
                                        OR
                                        trx_transaksi_status LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc='00'
                                        OR
                                        trx_transaksi_nomor LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='00'
                                        OR
                                        trx_transaksi_kategori LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='00'");
        } else {
            $sukses = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_sukses_total,
                                        count(trx_transaksi_kode) as statistik_sukses_jumlah from tbl_trx_transaksi
                                        where trx_transaksi_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_transaksi_rc='00'");
        }

        if ($sukses->num_rows() > 0) {
            foreach ($sukses->result() as $row) {
                $data['statistik_sukses_total'] = number_format($row->statistik_sukses_total, 0, ',', '.');
                $data['statistik_sukses_jumlah'] = number_format($row->statistik_sukses_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_sukses_total'] = '0';
            $data['statistik_sukses_jumlah'] = '0';
        }

        //PENDING
        if (strlen($txt_cari) > 0) {
            $pending = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_pending_total,
                                        count(trx_transaksi_kode) as statistik_pending_jumlah from tbl_trx_transaksi
                                        where
                                        trx_transaksi_kode LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='03'
                                        OR
                                        trx_transaksi_nama LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc='03'
                                        OR
                                        trx_transaksi_status LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc='03'
                                        OR
                                        trx_transaksi_nomor LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='03'
                                        OR
                                        trx_transaksi_kategori LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc='03'");
        } else {
            $pending = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_pending_total,
                                        count(trx_transaksi_kode) as statistik_pending_jumlah from tbl_trx_transaksi
                                        where trx_transaksi_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_transaksi_rc='03'");
        }

        if ($pending->num_rows() > 0) {
            foreach ($pending->result() as $row) {
                $data['statistik_pending_total'] = number_format($row->statistik_pending_total, 0, ',', '.');
                $data['statistik_pending_jumlah'] = number_format($row->statistik_pending_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_pending_total'] = '0';
            $data['statistik_pending_jumlah'] = '0';
        }

        //GAGAL
        if (strlen($txt_cari) > 0) {
            $gagal = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_gagal_total,
                                        count(trx_transaksi_kode) as statistik_gagal_jumlah from tbl_trx_transaksi
                                        where
                                        trx_transaksi_kode LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')
                                        OR
                                        trx_transaksi_nama LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')
                                        OR
                                        trx_transaksi_status LIKE '%$txt_cari%' and 
                                        trx_transaksi_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')
                                        OR
                                        trx_transaksi_nomor LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')
                                        OR
                                        trx_transaksi_kategori LIKE '%$txt_cari%'and 
                                        trx_transaksi_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')");
        } else {
            $gagal = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_gagal_total,
                                        count(trx_transaksi_kode) as statistik_gagal_jumlah from tbl_trx_transaksi
                                        where trx_transaksi_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and trx_transaksi_rc in ('02', '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '62', '63', '64')");
        }

        if ($gagal->num_rows() > 0) {
            foreach ($gagal->result() as $row) {
                $data['statistik_gagal_total'] = number_format($row->statistik_gagal_total, 0, ',', '.');
                $data['statistik_gagal_jumlah'] = number_format($row->statistik_gagal_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_gagal_total'] = '0';
            $data['statistik_gagal_jumlah'] = '0';
        }

        //SEMUA
        if (strlen($txt_cari) > 0) {
            $semua = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_semua_total,
                                        count(trx_transaksi_kode) as statistik_semua_jumlah from tbl_trx_transaksi
                                        where
                                        trx_transaksi_kode LIKE '%$txt_cari%' 
                                        OR
                                        trx_transaksi_nama LIKE '%$txt_cari%'
                                        OR
                                        trx_transaksi_status LIKE '%$txt_cari%' 
                                        OR
                                        trx_transaksi_nomor LIKE '%$txt_cari%'
                                        OR
                                        trx_transaksi_kategori LIKE '%$txt_cari%'");
        } else {
            $semua = $db_arifahpulsa_api->query("SELECT sum(trx_transaksi_jumlah) as statistik_semua_total,
                                        count(trx_transaksi_kode) as statistik_semua_jumlah from tbl_trx_transaksi
                                        where trx_transaksi_tanggal BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'");
        }

        if ($semua->num_rows() > 0) {
            foreach ($semua->result() as $row) {
                $data['statistik_semua_total'] = number_format($row->statistik_semua_total, 0, ',', '.');
                $data['statistik_semua_jumlah'] = number_format($row->statistik_semua_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_semua_total'] = '0';
            $data['statistik_semua_jumlah'] = '0';
        }

        echo json_encode($data);
    }

    function aksi_transaksi()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('dashboard');

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        if (strlen($txt_cari) > 0) {
            $list = $this->transaksi_dashboard->get_datatables_cari($txt_cari);
        } else {
            $list = $this->transaksi_dashboard->get_datatables_tanggal($tanggal_awal, $tanggal_akhir);
        }


        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            //STATUS
            $trx_transaksi_status = "<div class='btn btn-success'>$field->trx_transaksi_status</div>";
            $trx_transaksi_kategori = "<div class='btn btn-warning'>" . strtoupper($field->trx_transaksi_kategori) . "</div>";

            $row[] = $no;
            $row[] = $trx_transaksi_status;
            $row[] = $trx_transaksi_kategori;
            $row[] = $field->trx_transaksi_user_kode;
            $row[] = $field->mst_user_nama_lengkap;
            $row[] = $field->trx_transaksi_kode;
            $row[] = $field->trx_transaksi_nomor;
            $row[] = $field->trx_transaksi_nama;
            $row[] = number_format($field->trx_transaksi_jumlah, 0, ',', '.');
            $row[] = $field->trx_transaksi_keterangan;
            $row[] = $field->trx_transaksi_notasi;
            $row[] = date("d M Y H:i:s", strtotime($field->trx_transaksi_tanggal));
            $row[] = $field->trx_transaksi_rc;
            $data[] = $row;
        }

        if (strlen($txt_cari) > 0) {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->transaksi_dashboard->count_all_cari($txt_cari),
                "recordsFiltered" => $this->transaksi_dashboard->count_filtered_cari($txt_cari),
                "data" => $data,
            );
        } else {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->transaksi_dashboard->count_all_tanggal($tanggal_awal, $tanggal_akhir),
                "recordsFiltered" => $this->transaksi_dashboard->count_filtered_tanggal($tanggal_awal, $tanggal_akhir),
                "data" => $data,
            );
        }

        echo json_encode($output);
    }

    function aksi_grafik()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('dashboard');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $hari = date("d");
        $bulan = date("m");
        $tahun = date("Y");
        for ($i = 0; $i <= cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun) - 1; $i++) {
            $date = date('d-m-Y', strtotime($i  . '-' . $bulan . '-' . $tahun . ' +1 day'));
            $tanggal = date('d', strtotime($i . '-' . $bulan . '-' . $tahun . ' +1 day'));
            $query = $db_arifahpulsa_api->query("SELECT DATE_FORMAT(trx_transaksi_tanggal, '%d') as tanggal_transaksi,
                                    count(trx_transaksi_kode) as jumlah_transaksi
									from tbl_trx_transaksi 
									where DATE_FORMAT(trx_transaksi_tanggal, '%d-%m-%Y') = '$date' 
                                    and trx_transaksi_rc in ('1','00','03')
									group by DATE_FORMAT(trx_transaksi_tanggal, '%d-%m-%Y')");
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    $data['transaksi_item'][] = array(
                        $row->tanggal_transaksi,
                        $row->jumlah_transaksi
                    );
                }
            } else {
                $data['transaksi_item'][] = array(
                    $tanggal,
                    '0'
                );
            }
            $data['hari_item'][] = $tanggal;
            unset($date);
            unset($tanggal);
        }
        $data['bulan_item'][] = date("F");
        $data['tahun_item'][] = $tahun;

        $jumlah = $db_arifahpulsa_api->query("SELECT count(trx_transaksi_kode) as jumlah_transaksi
									from tbl_trx_transaksi 
									where DATE_FORMAT(trx_transaksi_tanggal, '%m-%Y') = '$bulan-$tahun'
                                    and trx_transaksi_rc in ('1','00','03')
                                    group by DATE_FORMAT(trx_transaksi_tanggal, '%m-%Y')");
        if ($jumlah->num_rows() > 0) {
            foreach ($jumlah->result() as $row) {
                $data['jumlah_item'][] = $row->jumlah_transaksi;
            }
        } else {
            $data['jumlah_item'][] = '0';
        }


        echo json_encode($data);
    }

    function aksi_produk_prabayar()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('dashboard');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url = "https://api.digiflazz.com/v1/price-list";

        $header = array(
            'Content-Type: text/plain',
        );

        $data = array(
            'cmd' => 'prepaid',
            'username' => $this->config->item('digiflazz_api_username'),
            'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . 'pricelist')
        );

        $json = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($result, true)['data'];

        foreach ($response as $data) {
            //DIGIFLAZZ
            $buyer_sku_code = $data['buyer_sku_code'];
            $price = $data['price'];
            $seller_product_status = $data['seller_product_status'];
            $buyer_product_status = $data['buyer_product_status'];

            if ($seller_product_status === true && $buyer_product_status === true) {
                //AKTIF
                $tbl_mst_pulsa[] = array(
                    'mst_pulsa_kode' => $buyer_sku_code,
                    'mst_pulsa_harga' =>  $price,
                    'mst_pulsa_status' =>  '0'
                );

                $tbl_mst_paket_data[] = array(
                    'mst_paket_data_kode' => $buyer_sku_code,
                    'mst_paket_data_harga' =>  $price,
                    'mst_paket_data_status' =>  '0'
                );

                $tbl_mst_paket_nelfon[] = array(
                    'mst_paket_nelfon_kode' => $buyer_sku_code,
                    'mst_paket_nelfon_harga' =>  $price,
                    'mst_paket_nelfon_status' =>  '0'
                );

                $tbl_mst_paket_sms[] = array(
                    'mst_paket_sms_kode' => $buyer_sku_code,
                    'mst_paket_sms_harga' =>  $price,
                    'mst_paket_sms_status' =>  '0'
                );

                $tbl_mst_token_pln[] = array(
                    'mst_token_pln_kode' => $buyer_sku_code,
                    'mst_token_pln_harga' =>  $price,
                    'mst_token_pln_status' =>  '0'
                );

                $tbl_mst_masa_aktif[] = array(
                    'mst_masa_aktif_kode' => $buyer_sku_code,
                    'mst_masa_aktif_harga' =>  $price,
                    'mst_masa_aktif_status' =>  '0'
                );

                $tbl_mst_pulsa_transfer[] = array(
                    'mst_pulsa_transfer_kode' => $buyer_sku_code,
                    'mst_pulsa_transfer_harga' =>  $price,
                    'mst_pulsa_transfer_status' =>  '0'
                );

                $tbl_mst_game[] = array(
                    'mst_game_kode' => $buyer_sku_code,
                    'mst_game_harga' =>  $price,
                    'mst_game_status' =>  '0'
                );

                $tbl_mst_gopay[] = array(
                    'mst_gopay_kode' => $buyer_sku_code,
                    'mst_gopay_harga' =>  $price,
                    'mst_gopay_status' =>  '0'
                );

                $tbl_mst_ovo[] = array(
                    'mst_ovo_kode' => $buyer_sku_code,
                    'mst_ovo_harga' =>  $price,
                    'mst_ovo_status' =>  '0'
                );

                $tbl_mst_linkaja[] = array(
                    'mst_linkaja_kode' => $buyer_sku_code,
                    'mst_linkaja_harga' =>  $price,
                    'mst_linkaja_status' =>  '0'
                );

                $tbl_mst_maxim[] = array(
                    'mst_maxim_kode' => $buyer_sku_code,
                    'mst_maxim_harga' =>  $price,
                    'mst_maxim_status' =>  '0'
                );

                $tbl_mst_dana[] = array(
                    'mst_dana_kode' => $buyer_sku_code,
                    'mst_dana_harga' =>  $price,
                    'mst_dana_status' =>  '0'
                );

                $tbl_mst_shopeepay[] = array(
                    'mst_shopeepay_kode' => $buyer_sku_code,
                    'mst_shopeepay_harga' =>  $price,
                    'mst_shopeepay_status' =>  '0'
                );

                $tbl_mst_doku[] = array(
                    'mst_doku_kode' => $buyer_sku_code,
                    'mst_doku_harga' =>  $price,
                    'mst_doku_status' =>  '0'
                );

                $tbl_mst_grab[] = array(
                    'mst_grab_kode' => $buyer_sku_code,
                    'mst_grab_harga' =>  $price,
                    'mst_grab_status' =>  '0'
                );

                $tbl_mst_sakuku[] = array(
                    'mst_sakuku_kode' => $buyer_sku_code,
                    'mst_sakuku_harga' =>  $price,
                    'mst_sakuku_status' =>  '0'
                );

                $tbl_mst_isaku[] = array(
                    'mst_isaku_kode' => $buyer_sku_code,
                    'mst_isaku_harga' =>  $price,
                    'mst_isaku_status' =>  '0'
                );

                $tbl_mst_gojek_driver[] = array(
                    'mst_gojek_driver_kode' => $buyer_sku_code,
                    'mst_gojek_driver_harga' =>  $price,
                    'mst_gojek_driver_status' =>  '0'
                );

                $tbl_mst_maxim_driver[] = array(
                    'mst_maxim_driver_kode' => $buyer_sku_code,
                    'mst_maxim_driver_harga' =>  $price,
                    'mst_maxim_driver_status' =>  '0'
                );

                $tbl_mst_grab_driver[] = array(
                    'mst_grab_driver_kode' => $buyer_sku_code,
                    'mst_grab_driver_harga' =>  $price,
                    'mst_grab_driver_status' =>  '0'
                );

                $tbl_mst_shopee_driver[] = array(
                    'mst_shopee_driver_kode' => $buyer_sku_code,
                    'mst_shopee_driver_harga' =>  $price,
                    'mst_shopee_driver_status' =>  '0'
                );

                $tbl_mst_indomaret[] = array(
                    'mst_indomaret_kode' => $buyer_sku_code,
                    'mst_indomaret_harga' =>  $price,
                    'mst_indomaret_status' =>  '0'
                );

                $tbl_mst_alfamart[] = array(
                    'mst_alfamart_kode' => $buyer_sku_code,
                    'mst_alfamart_harga' =>  $price,
                    'mst_alfamart_status' =>  '0'
                );

                $tbl_mst_tokopedia[] = array(
                    'mst_tokopedia_kode' => $buyer_sku_code,
                    'mst_tokopedia_harga' =>  $price,
                    'mst_tokopedia_status' =>  '0'
                );

                $tbl_mst_materai[] = array(
                    'mst_materai_kode' => $buyer_sku_code,
                    'mst_materai_harga' =>  $price,
                    'mst_materai_status' =>  '0'
                );

                $tbl_mst_traveloka[] = array(
                    'mst_traveloka_kode' => $buyer_sku_code,
                    'mst_traveloka_harga' =>  $price,
                    'mst_traveloka_status' =>  '0'
                );

                $tbl_mst_mtix[] = array(
                    'mst_mtix_kode' => $buyer_sku_code,
                    'mst_mtix_harga' =>  $price,
                    'mst_mtix_status' =>  '0'
                );

                $tbl_mst_tixid[] = array(
                    'mst_tixid_kode' => $buyer_sku_code,
                    'mst_tixid_harga' =>  $price,
                    'mst_tixid_status' =>  '0'
                );

                $tbl_mst_spotify[] = array(
                    'mst_spotify_kode' => $buyer_sku_code,
                    'mst_spotify_harga' =>  $price,
                    'mst_spotify_status' =>  '0'
                );

                $tbl_mst_googleplay[] = array(
                    'mst_googleplay_kode' => $buyer_sku_code,
                    'mst_googleplay_harga' =>  $price,
                    'mst_googleplay_status' =>  '0'
                );

                $tbl_mst_vidio[] = array(
                    'mst_vidio_kode' => $buyer_sku_code,
                    'mst_vidio_harga' =>  $price,
                    'mst_vidio_status' =>  '0'
                );

                $tbl_mst_unipin[] = array(
                    'mst_unipin_kode' => $buyer_sku_code,
                    'mst_unipin_harga' =>  $price,
                    'mst_unipin_status' =>  '0'
                );

                $tbl_mst_wifiid[] = array(
                    'mst_wifiid_kode' => $buyer_sku_code,
                    'mst_wifiid_harga' =>  $price,
                    'mst_wifiid_status' =>  '0'
                );

                $tbl_mst_emoney[] = array(
                    'mst_emoney_kode' => $buyer_sku_code,
                    'mst_emoney_harga' =>  $price,
                    'mst_emoney_status' =>  '0'
                );

                $tbl_mst_tapcash[] = array(
                    'mst_tapcash_kode' => $buyer_sku_code,
                    'mst_tapcash_harga' =>  $price,
                    'mst_tapcash_status' =>  '0'
                );

                $tbl_mst_brizzi[] = array(
                    'mst_brizzi_kode' => $buyer_sku_code,
                    'mst_brizzi_harga' =>  $price,
                    'mst_brizzi_status' =>  '0'
                );
            } else {
                //TIDAK AKTIF
                $tbl_mst_pulsa[] = array(
                    'mst_pulsa_kode' => $buyer_sku_code,
                    'mst_pulsa_harga' =>  $price,
                    'mst_pulsa_status' =>  '1'
                );

                $tbl_mst_paket_data[] = array(
                    'mst_paket_data_kode' => $buyer_sku_code,
                    'mst_paket_data_harga' =>  $price,
                    'mst_paket_data_status' =>  '1'
                );

                $tbl_mst_paket_nelfon[] = array(
                    'mst_paket_nelfon_kode' => $buyer_sku_code,
                    'mst_paket_nelfon_harga' =>  $price,
                    'mst_paket_nelfon_status' =>  '1'
                );

                $tbl_mst_paket_sms[] = array(
                    'mst_paket_sms_kode' => $buyer_sku_code,
                    'mst_paket_sms_harga' =>  $price,
                    'mst_paket_sms_status' =>  '1'
                );

                $tbl_mst_token_pln[] = array(
                    'mst_token_pln_kode' => $buyer_sku_code,
                    'mst_token_pln_harga' =>  $price,
                    'mst_token_pln_status' =>  '1'
                );

                $tbl_mst_masa_aktif[] = array(
                    'mst_masa_aktif_kode' => $buyer_sku_code,
                    'mst_masa_aktif_harga' =>  $price,
                    'mst_masa_aktif_status' =>  '1'
                );

                $tbl_mst_pulsa_transfer[] = array(
                    'mst_pulsa_transfer_kode' => $buyer_sku_code,
                    'mst_pulsa_transfer_harga' =>  $price,
                    'mst_pulsa_transfer_status' =>  '1'
                );

                $tbl_mst_game[] = array(
                    'mst_game_kode' => $buyer_sku_code,
                    'mst_game_harga' =>  $price,
                    'mst_game_status' =>  '1'
                );

                $tbl_mst_gopay[] = array(
                    'mst_gopay_kode' => $buyer_sku_code,
                    'mst_gopay_harga' =>  $price,
                    'mst_gopay_status' =>  '1'
                );

                $tbl_mst_ovo[] = array(
                    'mst_ovo_kode' => $buyer_sku_code,
                    'mst_ovo_harga' =>  $price,
                    'mst_ovo_status' =>  '1'
                );

                $tbl_mst_linkaja[] = array(
                    'mst_linkaja_kode' => $buyer_sku_code,
                    'mst_linkaja_harga' =>  $price,
                    'mst_linkaja_status' =>  '1'
                );

                $tbl_mst_maxim[] = array(
                    'mst_maxim_kode' => $buyer_sku_code,
                    'mst_maxim_harga' =>  $price,
                    'mst_maxim_status' =>  '1'
                );

                $tbl_mst_dana[] = array(
                    'mst_dana_kode' => $buyer_sku_code,
                    'mst_dana_harga' =>  $price,
                    'mst_dana_status' =>  '1'
                );

                $tbl_mst_shopeepay[] = array(
                    'mst_shopeepay_kode' => $buyer_sku_code,
                    'mst_shopeepay_harga' =>  $price,
                    'mst_shopeepay_status' =>  '1'
                );

                $tbl_mst_doku[] = array(
                    'mst_doku_kode' => $buyer_sku_code,
                    'mst_doku_harga' =>  $price,
                    'mst_doku_status' =>  '1'
                );

                $tbl_mst_grab[] = array(
                    'mst_grab_kode' => $buyer_sku_code,
                    'mst_grab_harga' =>  $price,
                    'mst_grab_status' =>  '1'
                );

                $tbl_mst_sakuku[] = array(
                    'mst_sakuku_kode' => $buyer_sku_code,
                    'mst_sakuku_harga' =>  $price,
                    'mst_sakuku_status' =>  '1'
                );

                $tbl_mst_isaku[] = array(
                    'mst_isaku_kode' => $buyer_sku_code,
                    'mst_isaku_harga' =>  $price,
                    'mst_isaku_status' =>  '1'
                );

                $tbl_mst_gojek_driver[] = array(
                    'mst_gojek_driver_kode' => $buyer_sku_code,
                    'mst_gojek_driver_harga' =>  $price,
                    'mst_gojek_driver_status' =>  '1'
                );

                $tbl_mst_maxim_driver[] = array(
                    'mst_maxim_driver_kode' => $buyer_sku_code,
                    'mst_maxim_driver_harga' =>  $price,
                    'mst_maxim_driver_status' =>  '1'
                );

                $tbl_mst_grab_driver[] = array(
                    'mst_grab_driver_kode' => $buyer_sku_code,
                    'mst_grab_driver_harga' =>  $price,
                    'mst_grab_driver_status' =>  '1'
                );

                $tbl_mst_shopee_driver[] = array(
                    'mst_shopee_driver_kode' => $buyer_sku_code,
                    'mst_shopee_driver_harga' =>  $price,
                    'mst_shopee_driver_status' =>  '1'
                );

                $tbl_mst_indomaret[] = array(
                    'mst_indomaret_kode' => $buyer_sku_code,
                    'mst_indomaret_harga' =>  $price,
                    'mst_indomaret_status' =>  '1'
                );

                $tbl_mst_alfamart[] = array(
                    'mst_alfamart_kode' => $buyer_sku_code,
                    'mst_alfamart_harga' =>  $price,
                    'mst_alfamart_status' =>  '1'
                );

                $tbl_mst_tokopedia[] = array(
                    'mst_tokopedia_kode' => $buyer_sku_code,
                    'mst_tokopedia_harga' =>  $price,
                    'mst_tokopedia_status' =>  '1'
                );

                $tbl_mst_materai[] = array(
                    'mst_materai_kode' => $buyer_sku_code,
                    'mst_materai_harga' =>  $price,
                    'mst_materai_status' =>  '1'
                );

                $tbl_mst_traveloka[] = array(
                    'mst_traveloka_kode' => $buyer_sku_code,
                    'mst_traveloka_harga' =>  $price,
                    'mst_traveloka_status' =>  '1'
                );

                $tbl_mst_mtix[] = array(
                    'mst_mtix_kode' => $buyer_sku_code,
                    'mst_mtix_harga' =>  $price,
                    'mst_mtix_status' =>  '1'
                );

                $tbl_mst_tixid[] = array(
                    'mst_tixid_kode' => $buyer_sku_code,
                    'mst_tixid_harga' =>  $price,
                    'mst_tixid_status' =>  '1'
                );

                $tbl_mst_spotify[] = array(
                    'mst_spotify_kode' => $buyer_sku_code,
                    'mst_spotify_harga' =>  $price,
                    'mst_spotify_status' =>  '1'
                );

                $tbl_mst_googleplay[] = array(
                    'mst_googleplay_kode' => $buyer_sku_code,
                    'mst_googleplay_harga' =>  $price,
                    'mst_googleplay_status' =>  '1'
                );

                $tbl_mst_vidio[] = array(
                    'mst_vidio_kode' => $buyer_sku_code,
                    'mst_vidio_harga' =>  $price,
                    'mst_vidio_status' =>  '1'
                );

                $tbl_mst_unipin[] = array(
                    'mst_unipin_kode' => $buyer_sku_code,
                    'mst_unipin_harga' =>  $price,
                    'mst_unipin_status' =>  '1'
                );

                $tbl_mst_wifiid[] = array(
                    'mst_wifiid_kode' => $buyer_sku_code,
                    'mst_wifiid_harga' =>  $price,
                    'mst_wifiid_status' =>  '1'
                );

                $tbl_mst_emoney[] = array(
                    'mst_emoney_kode' => $buyer_sku_code,
                    'mst_emoney_harga' =>  $price,
                    'mst_emoney_status' =>  '1'
                );

                $tbl_mst_tapcash[] = array(
                    'mst_tapcash_kode' => $buyer_sku_code,
                    'mst_tapcash_harga' =>  $price,
                    'mst_tapcash_status' =>  '1'
                );

                $tbl_mst_brizzi[] = array(
                    'mst_brizzi_kode' => $buyer_sku_code,
                    'mst_brizzi_harga' =>  $price,
                    'mst_brizzi_status' =>  '1'
                );
            }
        }

        //UPDATE
        $db_arifahpulsa_api->update_batch('tbl_mst_pulsa', $tbl_mst_pulsa, 'mst_pulsa_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_paket_data', $tbl_mst_paket_data, 'mst_paket_data_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_paket_nelfon', $tbl_mst_paket_nelfon, 'mst_paket_nelfon_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_paket_sms', $tbl_mst_paket_sms, 'mst_paket_sms_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_token_pln', $tbl_mst_token_pln, 'mst_token_pln_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_masa_aktif', $tbl_mst_masa_aktif, 'mst_masa_aktif_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_pulsa_transfer', $tbl_mst_pulsa_transfer, 'mst_pulsa_transfer_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_game', $tbl_mst_game, 'mst_game_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_gopay', $tbl_mst_gopay, 'mst_gopay_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_ovo', $tbl_mst_ovo, 'mst_ovo_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_linkaja', $tbl_mst_linkaja, 'mst_linkaja_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_maxim', $tbl_mst_maxim, 'mst_maxim_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_dana', $tbl_mst_dana, 'mst_dana_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_shopeepay', $tbl_mst_shopeepay, 'mst_shopeepay_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_doku', $tbl_mst_doku, 'mst_doku_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_grab', $tbl_mst_grab, 'mst_grab_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_sakuku', $tbl_mst_sakuku, 'mst_sakuku_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_isaku', $tbl_mst_isaku, 'mst_isaku_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_gojek_driver', $tbl_mst_gojek_driver, 'mst_gojek_driver_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_maxim_driver', $tbl_mst_maxim_driver, 'mst_maxim_driver_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_grab_driver', $tbl_mst_grab_driver, 'mst_grab_driver_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_shopee_driver', $tbl_mst_shopee_driver, 'mst_shopee_driver_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_indomaret', $tbl_mst_indomaret, 'mst_indomaret_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_alfamart', $tbl_mst_alfamart, 'mst_alfamart_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_tokopedia', $tbl_mst_tokopedia, 'mst_tokopedia_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_materai', $tbl_mst_materai, 'mst_materai_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_traveloka', $tbl_mst_traveloka, 'mst_traveloka_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_mtix', $tbl_mst_mtix, 'mst_mtix_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_tixid', $tbl_mst_tixid, 'mst_tixid_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_spotify', $tbl_mst_spotify, 'mst_spotify_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_googleplay', $tbl_mst_googleplay, 'mst_googleplay_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_vidio', $tbl_mst_vidio, 'mst_vidio_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_unipin', $tbl_mst_unipin, 'mst_unipin_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_wifiid', $tbl_mst_wifiid, 'mst_wifiid_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_emoney', $tbl_mst_emoney, 'mst_emoney_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_tapcash', $tbl_mst_tapcash, 'mst_tapcash_kode');
        $db_arifahpulsa_api->update_batch('tbl_mst_brizzi', $tbl_mst_brizzi, 'mst_brizzi_kode');

        //MENAMPILKAN PRODUK
        $query = $db_arifahpulsa_api->query("SELECT mst_pulsa_nama as produk_nama, 
                                            mst_pulsa_harga as produk_harga, 
                                            mst_pulsa_status as produk_status 
                                            from tbl_mst_pulsa where mst_pulsa_status='1'
                                            UNION
                                            SELECT mst_paket_data_nama as produk_nama, 
                                            mst_paket_data_harga as produk_harga, 
                                            mst_paket_data_status as produk_status 
                                            from tbl_mst_paket_data where mst_paket_data_status='1'
                                            UNION
                                            SELECT mst_paket_nelfon_nama as produk_nama, 
                                            mst_paket_nelfon_harga as produk_harga, 
                                            mst_paket_nelfon_status as produk_status 
                                            from tbl_mst_paket_nelfon where mst_paket_nelfon_status='1'
                                            UNION
                                            SELECT mst_paket_sms_nama as produk_nama, 
                                            mst_paket_sms_harga as produk_harga, 
                                            mst_paket_sms_status as produk_status 
                                            from tbl_mst_paket_sms where mst_paket_sms_status='1'
                                            UNION
                                            SELECT mst_token_pln_nama as produk_nama, 
                                            mst_token_pln_harga as produk_harga, 
                                            mst_token_pln_status as produk_status 
                                            from tbl_mst_token_pln where mst_token_pln_status='1'
                                            UNION
                                            SELECT mst_masa_aktif_nama as produk_nama, 
                                            mst_masa_aktif_harga as produk_harga, 
                                            mst_masa_aktif_status as produk_status 
                                            from tbl_mst_masa_aktif where mst_masa_aktif_status='1'
                                            UNION
                                            SELECT mst_pulsa_transfer_nama as produk_nama, 
                                            mst_pulsa_transfer_harga as produk_harga, 
                                            mst_pulsa_transfer_status as produk_status 
                                            from tbl_mst_pulsa_transfer where mst_pulsa_transfer_status='1'
                                            UNION
                                            SELECT mst_game_nama as produk_nama, 
                                            mst_game_harga as produk_harga, 
                                            mst_game_status as produk_status 
                                            from tbl_mst_game where mst_game_status='1'
                                            UNION
                                            SELECT mst_gopay_nama as produk_nama, 
                                            mst_gopay_harga as produk_harga, 
                                            mst_gopay_status as produk_status 
                                            from tbl_mst_gopay where mst_gopay_status='1'
                                            UNION
                                            SELECT mst_ovo_nama as produk_nama, 
                                            mst_ovo_harga as produk_harga, 
                                            mst_ovo_status as produk_status 
                                            from tbl_mst_ovo where mst_ovo_status='1'
                                            UNION
                                            SELECT mst_linkaja_nama as produk_nama, 
                                            mst_linkaja_harga as produk_harga, 
                                            mst_linkaja_status as produk_status 
                                            from tbl_mst_linkaja where mst_linkaja_status='1'
                                            UNION
                                            SELECT mst_maxim_nama as produk_nama, 
                                            mst_maxim_harga as produk_harga, 
                                            mst_maxim_status as produk_status 
                                            from tbl_mst_maxim where mst_maxim_status='1'
                                            UNION
                                            SELECT mst_dana_nama as produk_nama, 
                                            mst_dana_harga as produk_harga, 
                                            mst_dana_status as produk_status 
                                            from tbl_mst_dana where mst_dana_status='1'
                                            UNION
                                            SELECT mst_shopeepay_nama as produk_nama, 
                                            mst_shopeepay_harga as produk_harga, 
                                            mst_shopeepay_status as produk_status 
                                            from tbl_mst_shopeepay where mst_shopeepay_status='1'
                                            UNION
                                            SELECT mst_doku_nama as produk_nama, 
                                            mst_doku_harga as produk_harga, 
                                            mst_doku_status as produk_status 
                                            from tbl_mst_doku where mst_doku_status='1'
                                            UNION
                                            SELECT mst_grab_nama as produk_nama, 
                                            mst_grab_harga as produk_harga, 
                                            mst_grab_status as produk_status 
                                            from tbl_mst_grab where mst_grab_status='1'
                                            UNION
                                            SELECT mst_sakuku_nama as produk_nama, 
                                            mst_sakuku_harga as produk_harga, 
                                            mst_sakuku_status as produk_status 
                                            from tbl_mst_sakuku where mst_sakuku_status='1'
                                            UNION
                                            SELECT mst_isaku_nama as produk_nama, 
                                            mst_isaku_harga as produk_harga, 
                                            mst_isaku_status as produk_status 
                                            from tbl_mst_isaku where mst_isaku_status='1'
                                            UNION
                                            SELECT mst_gojek_driver_nama as produk_nama, 
                                            mst_gojek_driver_harga as produk_harga, 
                                            mst_gojek_driver_status as produk_status 
                                            from tbl_mst_gojek_driver where mst_gojek_driver_status='1'
                                            UNION
                                            SELECT mst_maxim_driver_nama as produk_nama, 
                                            mst_maxim_driver_harga as produk_harga, 
                                            mst_maxim_driver_status as produk_status 
                                            from tbl_mst_maxim_driver where mst_maxim_driver_status='1'
                                            UNION
                                            SELECT mst_grab_driver_nama as produk_nama, 
                                            mst_grab_driver_harga as produk_harga, 
                                            mst_grab_driver_status as produk_status 
                                            from tbl_mst_grab_driver where mst_grab_driver_status='1'
                                            UNION
                                            SELECT mst_shopee_driver_nama as produk_nama, 
                                            mst_shopee_driver_harga as produk_harga, 
                                            mst_shopee_driver_status as produk_status 
                                            from tbl_mst_shopee_driver where mst_shopee_driver_status='1'
                                            UNION
                                            SELECT mst_indomaret_nama as produk_nama, 
                                            mst_indomaret_harga as produk_harga, 
                                            mst_indomaret_status as produk_status 
                                            from tbl_mst_indomaret where mst_indomaret_status='1'
                                            UNION
                                            SELECT mst_alfamart_nama as produk_nama, 
                                            mst_alfamart_harga as produk_harga, 
                                            mst_alfamart_status as produk_status 
                                            from tbl_mst_alfamart where mst_alfamart_status='1'
                                            UNION
                                            SELECT mst_tokopedia_nama as produk_nama, 
                                            mst_tokopedia_harga as produk_harga, 
                                            mst_tokopedia_status as produk_status 
                                            from tbl_mst_tokopedia where mst_tokopedia_status='1'
                                            UNION
                                            SELECT mst_materai_nama as produk_nama, 
                                            mst_materai_harga as produk_harga, 
                                            mst_materai_status as produk_status 
                                            from tbl_mst_materai where mst_materai_status='1'
                                            UNION
                                            SELECT mst_traveloka_nama as produk_nama, 
                                            mst_traveloka_harga as produk_harga, 
                                            mst_traveloka_status as produk_status 
                                            from tbl_mst_traveloka where mst_traveloka_status='1'
                                            UNION
                                            SELECT mst_mtix_nama as produk_nama, 
                                            mst_mtix_harga as produk_harga, 
                                            mst_mtix_status as produk_status 
                                            from tbl_mst_mtix where mst_mtix_status='1'
                                            UNION
                                            SELECT mst_tixid_nama as produk_nama, 
                                            mst_tixid_harga as produk_harga, 
                                            mst_tixid_status as produk_status 
                                            from tbl_mst_tixid where mst_tixid_status='1'
                                            UNION
                                            SELECT mst_spotify_nama as produk_nama, 
                                            mst_spotify_harga as produk_harga, 
                                            mst_spotify_status as produk_status 
                                            from tbl_mst_spotify where mst_spotify_status='1'
                                            UNION
                                            SELECT mst_googleplay_nama as produk_nama, 
                                            mst_googleplay_harga as produk_harga, 
                                            mst_googleplay_status as produk_status 
                                            from tbl_mst_googleplay where mst_googleplay_status='1'
                                            UNION
                                            SELECT mst_vidio_nama as produk_nama, 
                                            mst_vidio_harga as produk_harga, 
                                            mst_vidio_status as produk_status 
                                            from tbl_mst_vidio where mst_vidio_status='1'
                                            UNION
                                            SELECT mst_unipin_nama as produk_nama, 
                                            mst_unipin_harga as produk_harga, 
                                            mst_unipin_status as produk_status 
                                            from tbl_mst_unipin where mst_unipin_status='1'
                                            UNION
                                            SELECT mst_wifiid_nama as produk_nama, 
                                            mst_wifiid_harga as produk_harga, 
                                            mst_wifiid_status as produk_status 
                                            from tbl_mst_wifiid where mst_wifiid_status='1'
                                            UNION
                                            SELECT mst_bukalapak_nama as produk_nama, 
                                            mst_bukalapak_harga as produk_harga, 
                                            mst_bukalapak_status as produk_status 
                                            from tbl_mst_bukalapak where mst_bukalapak_status='1'
                                            UNION
                                            SELECT mst_emoney_nama as produk_nama, 
                                            mst_emoney_harga as produk_harga, 
                                            mst_emoney_status as produk_status 
                                            from tbl_mst_emoney where mst_emoney_status='1'
                                            UNION
                                            SELECT mst_tapcash_nama as produk_nama, 
                                            mst_tapcash_harga as produk_harga, 
                                            mst_tapcash_status as produk_status 
                                            from tbl_mst_tapcash where mst_tapcash_status='1'
                                            UNION
                                            SELECT mst_brizzi_nama as produk_nama, 
                                            mst_brizzi_harga as produk_harga, 
                                            mst_brizzi_status as produk_status 
                                            from tbl_mst_brizzi where mst_brizzi_status='1'");


        echo "<table id='table_prabayar' class='table table-bordered table-striped' width='100%'> ";
        echo "  <thead>";
        echo "      <tr> ";
        echo "          <th align='center'>No.</th>";
        echo "          <th align='left'>Nama Produk</th> ";
        echo "          <th align='right'>Harga</th>";
        echo "          <th align='center'>Status</th>";
        echo "      </tr> ";
        echo "  </thead";
        echo "  <tbody>";
        $no = 1;
        foreach ($query->result() as $row) {
            echo "  <tr>";
            echo "      <td align='center'>$no</td>";
            echo "      <td align='left'> $row->produk_nama </td>";
            echo "      <td align='right'>" . number_format($row->produk_harga, 0, ',', '.') . "</td>";
            if ($row->produk_status == '0') {
                echo "      <td align='center'>Aktif</td>";
            } else {
                echo "      <td align='center'><div class='btn btn-danger'>Tidak Aktif</div></td>";
            }
            echo "   </tr>";
            $no++;
        }
        echo "  </tbody>";
        echo "</table>";

        echo "<script>
            $(function () {
                 $('#table_prabayar').DataTable({
                    'lengthChange': true,
                    'autoWidth': true,
                    'ordering': true,
                    'info': true,
                    'scrollX': true,
                    'sScrollX' : '100%',
                    'sScrollY': '500',
                    'paging': true,
                    'buttons': ['copy', 'print']
                }).buttons().container().appendTo('#table_wrapper .col-md-6:eq(0)');
           
            });

          
        </script>";
    }

    function aksi_produk_pascabayar()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('dashboard');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url = "https://api.digiflazz.com/v1/price-list";

        $header = array(
            'Content-Type: text/plain',
        );

        $data = array(
            'cmd' => 'pasca',
            'username' => $this->config->item('digiflazz_api_username'),
            'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . 'pricelist')
        );

        $json = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($result, true)['data'];

        foreach ($response as $data) {
            //DIGIFLAZZ

            $buyer_sku_code = $data['buyer_sku_code'];
            $product_name = $data['product_name'];
            $seller_product_status = $data['seller_product_status'];
            $buyer_product_status = $data['buyer_product_status'];

            if ($seller_product_status === true && $buyer_product_status === true) {
                if ($buyer_sku_code == 'pln_pascabayar') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Nomor pelanggan PLN dibutuhkan untuk melakukan transaksi', 
                                        mst_menu_status='0' where mst_menu_kode='M-012'");
                } else if ($buyer_sku_code == 'bpjs_kesehatan') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Nomor pelanggan BPSJ Kesehatan dibutuhkan untuk melakukan transaksi', 
                                        mst_menu_status='0' where mst_menu_kode='M-009'");
                } else if ($buyer_sku_code == 'gas_negara') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Nomor pelanggan gas negara dibutuhkan untuk melakukan transaksi', 
                                        mst_menu_status='0' where mst_menu_kode='M-017'");
                } else {
                    $hp[] = array(
                        'ktg_hp_kode' => $buyer_sku_code,
                        'ktg_hp_keterangan' =>  'Nomor HP dibutuhkan untuk melakukan transaksi',
                        'ktg_hp_status' =>  '0'
                    );

                    $internet[] = array(
                        'ktg_internet_kode' => $buyer_sku_code,
                        'ktg_internet_keterangan' =>  'Nomor pelanggan dibutuhkan untuk melakukan transaksi',
                        'ktg_internet_status' =>  '0'
                    );

                    $multifinance[] = array(
                        'ktg_multifinance_kode' => $buyer_sku_code,
                        'ktg_multifinance_keterangan' =>  'Nomor kontrak dibutuhkan untuk melakukan transaksi',
                        'ktg_multifinance_status' =>  '0'
                    );

                    $pbb[] = array(
                        'ktg_pbb_kode' => $buyer_sku_code,
                        'ktg_pbb_keterangan' =>  'Nomor objek pajak dibutuhkan untuk melakukan transaksi',
                        'ktg_pbb_status' =>  '0'
                    );

                    $pdam[] = array(
                        'ktg_pdam_kode' => $buyer_sku_code,
                        'ktg_pdam_keterangan' =>  'Nomor pelanggan dibutuhkan untuk melakukan transaksi',
                        'ktg_pdam_status' =>  '0'
                    );

                    $tv[] = array(
                        'ktg_tv_kode' => $buyer_sku_code,
                        'ktg_tv_keterangan' =>  'Nomor pelanggan dibutuhkan untuk melakukan transaksi',
                        'ktg_tv_status' =>  '0'
                    );
                }
            } else {
                if ($buyer_sku_code == 'pln_pascabayar') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Pembayaran listrik pln mengalami ganggaun, silahkan coba secara berkala', 
                                        mst_menu_status='1' where mst_menu_kode='M-012'");
                } else if ($buyer_sku_code == 'bpjs_kesehatan') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Pembayaran BPJS kesehatan mengalami ganggaun, silahkan coba secara berkala', 
                                        mst_menu_status='1' where mst_menu_kode='M-009'");
                } else if ($buyer_sku_code == 'gas_negara') {
                    $db_arifahpulsa_api->query("UPDATE tbl_mst_menu set 
                                        mst_menu_keterangan='Pembayaran Gas Negara mengalami ganggaun, silahkan coba secara berkala', 
                                        mst_menu_status='1' where mst_menu_kode='M-017'");
                } else {
                    $hp[] = array(
                        'ktg_hp_kode' => $buyer_sku_code,
                        'ktg_hp_keterangan' =>  'Pembayaran tagihan HP mengalami gangguan, silahkan coba secara berkala',
                        'ktg_hp_status' =>  '1'
                    );

                    $internet[] = array(
                        'ktg_internet_kode' => $buyer_sku_code,
                        'ktg_internet_keterangan' => 'Pembayaran tagihan internet mengalami gangguan, silahkan coba secara berkala',
                        'ktg_internet_status' =>  '1'
                    );

                    $multifinance[] = array(
                        'ktg_multifinance_kode' => $buyer_sku_code,
                        'ktg_multifinance_keterangan' =>  'Pembayaran tagihan kredit mengalami gangguan, silahkan coba secara berkala',
                        'ktg_multifinance_status' =>  '1'
                    );

                    $pbb[] = array(
                        'ktg_pbb_kode' => $buyer_sku_code,
                        'ktg_pbb_keterangan' =>  'Pembayaran pajak bumi dan bangunan mengalami gangguan, silahkan coba secara berkala',
                        'ktg_pbb_status' =>  '1'
                    );

                    $pdam[] = array(
                        'ktg_pdam_kode' => $buyer_sku_code,
                        'ktg_pdam_keterangan' =>  'Pembayaran tagihan PDAM mengalami gangguan, silahkan coba secara berkala',
                        'ktg_pdam_status' =>  '1'
                    );

                    $tv[] = array(
                        'ktg_tv_kode' => $buyer_sku_code,
                        'ktg_tv_keterangan' =>  'Pembayaran tagihan TV mengalami gangguan, silahkan coba secara berkala',
                        'ktg_tv_status' =>  '1'
                    );
                }
            }
        }

        //UPDATE
        $db_arifahpulsa_api->update_batch('tbl_ktg_hp', $hp, 'ktg_hp_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_internet', $internet, 'ktg_internet_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_multifinance', $multifinance, 'ktg_multifinance_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_pbb', $pbb, 'ktg_pbb_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_pdam', $pdam, 'ktg_pdam_kode');
        $db_arifahpulsa_api->update_batch('tbl_ktg_tv', $tv, 'ktg_tv_kode');

        //MENAMPILKAN PRODUK
        $query = $db_arifahpulsa_api->query("SELECT ktg_hp_nama as produk_nama, 
                                            ktg_hp_keterangan as produk_keterangan, 
                                            ktg_hp_status as produk_status 
                                            from tbl_ktg_hp where ktg_hp_status='1'
                                            UNION
                                            SELECT ktg_internet_nama as produk_nama, 
                                            ktg_internet_keterangan as produk_keterangan, 
                                            ktg_internet_status as produk_status 
                                            from tbl_ktg_internet where ktg_internet_status='1'
                                            UNION
                                            SELECT ktg_multifinance_nama as produk_nama, 
                                            ktg_multifinance_keterangan as produk_keterangan, 
                                            ktg_multifinance_status as produk_status 
                                            from tbl_ktg_multifinance where ktg_multifinance_status='1'
                                            UNION
                                            SELECT ktg_pbb_nama as produk_nama, 
                                            ktg_pbb_keterangan as produk_keterangan, 
                                            ktg_pbb_status as produk_status 
                                            from tbl_ktg_pbb where ktg_pbb_status='1'
                                            UNION
                                            SELECT ktg_pdam_nama as produk_nama, 
                                            ktg_pdam_keterangan as produk_keterangan, 
                                            ktg_pdam_status as produk_status 
                                            from tbl_ktg_pdam where ktg_pdam_status='1'
                                            UNION
                                            SELECT ktg_tv_nama as produk_nama, 
                                            ktg_tv_keterangan as produk_keterangan, 
                                            ktg_tv_status as produk_status 
                                            from tbl_ktg_tv where ktg_tv_status='1'
                                            UNION
                                            SELECT mst_menu_nama as produk_nama, 
                                            mst_menu_keterangan as produk_keterangan, 
                                            mst_menu_status as produk_status 
                                            from tbl_mst_menu where mst_menu_status='1' and mst_menu_grup='Bayar Tagihan'");


        echo "<table id='table_pascabayar' class='table table-bordered table-striped' width='100%'>";
        echo "  <thead>";
        echo "      <tr> ";
        echo "          <th align='center'>No.</th>";
        echo "          <th align='left'>Nama Produk</th> ";
        echo "          <th align='right'>Keterangan</th>";
        echo "          <th align='center'>Status</th>";
        echo "      </tr> ";
        echo "  </thead";
        echo "  <tbody>";
        $no = 1;
        foreach ($query->result() as $row) {
            echo "  <tr>";
            echo "      <td align='center'>$no</td>";
            echo "      <td align='left'> $row->produk_nama </td>";
            echo "      <td align='left'>$row->produk_keterangan</td>";
            if ($row->produk_status == '0') {
                echo "      <td align='center'>Aktif</td>";
            } else {
                echo "      <td align='center'><div class='btn btn-danger'>Tidak Aktif</div></td>";
            }
            echo "   </tr>";
            $no++;
        }
        echo "  </tbody>";
        echo "</table>";

        echo "<script>
            $(function () {
                 $('#table_pascabayar').DataTable({
                    'lengthChange': true,
                    'autoWidth': true,
                    'ordering': true,
                    'info': true,
                    'scrollX': true,
                    'sScrollX' : '100%',
                    'sScrollY': '500',
                    'paging': true,
                    'buttons': ['copy', 'print']
                }).buttons().container().appendTo('#table_wrapper .col-md-6:eq(0)');
           
            });

          
        </script>";
    }
}
