<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Poin_transaksi extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model('Model_poin_transaksi', 'poin_transaksi');
        return true;
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('poin_transaksi');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Transaksi Poin User';

        $this->template->load('includes/header', 'view_poin_transaksi', $data);
    }

    function aksi_poin()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('poin_transaksi');

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        if (strlen($txt_cari) > 0) {
            $list = $this->poin_transaksi->get_datatables_cari($txt_cari);
        } else {
            $list = $this->poin_transaksi->get_datatables_tanggal($tanggal_awal, $tanggal_akhir);
        }


        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->trx_poin_kode;
            $row[] = $field->trx_poin_user_kode;
            $row[] = $field->mst_user_nama_lengkap;
            $row[] = $field->trx_poin_nama;
            $row[] = $field->trx_poin_keterangan;
            $row[] = number_format($field->trx_poin_jumlah, 0, ',', '.');
            $row[] = date("d M Y H:i:s", strtotime($field->trx_poin_tanggal));
            $data[] = $row;
        }

        if (strlen($txt_cari) > 0) {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->poin_transaksi->count_all_cari($txt_cari),
                "recordsFiltered" => $this->poin_transaksi->count_filtered_cari($txt_cari),
                "data" => $data,
            );
        } else {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->poin_transaksi->count_all_tanggal($tanggal_awal, $tanggal_akhir),
                "recordsFiltered" => $this->poin_transaksi->count_filtered_tanggal($tanggal_awal, $tanggal_akhir),
                "data" => $data,
            );
        }

        echo json_encode($output);
    }
}
