<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Poin_user extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model('Model_poin_user', 'poin_user');
        return true;
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('poin_user');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Poin User';

        $this->template->load('includes/header', 'view_poin_user', $data);
    }


    function aksi_statistik()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('poin_user');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $txt_cari = $this->input->post("txt_cari");

        //SEMUA
        if (strlen($txt_cari) > 0) {
            $semua = $db_arifahpulsa_api->query("SELECT sum(mst_poin_jumlah) as statistik_semua_total from tbl_mst_user,tbl_mst_poin
                                        where
                                        mst_user_kode LIKE '%$txt_cari%' and
                                        mst_poin_user_kode=mst_user_kode
                                        OR
                                        mst_user_nama_lengkap LIKE '%$txt_cari%' and
                                        mst_poin_user_kode=mst_user_kode
                                        OR
                                        mst_user_nomor_hp LIKE '%$txt_cari%' and
                                        mst_poin_user_kode=mst_user_kode
                                        OR
                                        mst_user_email LIKE '%$txt_cari%' and
                                        mst_poin_user_kode=mst_user_kode");
        } else {
            $semua = $db_arifahpulsa_api->query("SELECT sum(mst_poin_jumlah) as statistik_semua_total from tbl_mst_user,tbl_mst_poin 
                                        where mst_poin_user_kode=mst_user_kode");
        }

        if ($semua->num_rows() > 0) {
            foreach ($semua->result() as $row) {
                $data['statistik_semua_total'] = number_format($row->statistik_semua_total, 0, ',', '.');
            }
        } else {
            $data['statistik_semua_total'] = '0';
        }

        echo json_encode($data);
    }

    function aksi_poin()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('poin_user');

        $txt_cari = $this->input->post("txt_cari");

        if (strlen($txt_cari) > 0) {
            $list = $this->poin_user->get_datatables_cari($txt_cari);
        } else {
            $list = $this->poin_user->get_datatables();
        }


        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            if ($this->Model_squrity->cekmenu_saldo('poin_user/tambah') == true) {
                $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                        <a class='dropdown-item' onclick=aksi_tambah_poin_user_modal(this)>TAMBAH POIN</a>
                        </div>
                        </button>
                    </div>";
            } else {
                $aksi = " <button type='button' class='btn btn-danger'>AKSES PENGISAN POIN MANUAL TIDAK ADA</button>";
            }


            $row[] = $no;
            $row[] = $aksi;
            $row[] = $field->mst_user_kode;
            $row[] = $field->mst_user_nama_lengkap;
            $row[] = $field->mst_user_nomor_hp;
            $row[] = $field->mst_user_email;
            $row[] = number_format($field->mst_poin_jumlah, 0, ',', '.');
            $data[] = $row;
        }

        if (strlen($txt_cari) > 0) {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->poin_user->count_all_cari($txt_cari),
                "recordsFiltered" => $this->poin_user->count_filtered_cari($txt_cari),
                "data" => $data,
            );
        } else {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->poin_user->count_all(),
                "recordsFiltered" => $this->poin_user->count_filtered(),
                "data" => $data,
            );
        }

        echo json_encode($output);
    }

    function aksi_tambah_poin_user()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('poin_user/tambah');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        //USER
        $mst_user_kode = $this->input->post("mst_user_kode");

        //POIN
        $trx_poin_kode = "POIN-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
        $trx_poin_tanggal = date('Y-m-d H:i:s');
        $trx_poin_jumlah = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("trx_poin_jumlah"));

        //NOTIFIKASI
        $mst_inbox_kode = "INBOX-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
        $notifikasi_judul = $this->input->post("notifikasi_judul");
        $notifikasi_isi = $this->input->post("notifikasi_isi");

        //PANGGIL USER
        $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$mst_user_kode'");
        if ($user->num_rows() > 0) {
            foreach ($user->result() as $row) {
                $mst_user_firebase = $row->mst_user_firebase;
            }

            //INSERT KE tbl_trx_poin
            $db_arifahpulsa_api->query("insert into tbl_trx_poin (
                        trx_poin_kode, 
                        trx_poin_user_kode, 
                        trx_poin_nama, 
                        trx_poin_keterangan, 
                        trx_poin_jumlah,
                        trx_poin_tanggal) values (
                        '$trx_poin_kode', 
                        '$mst_user_kode', 
                        'Manual',
                        'Poin dari penambahan manual', 
                        '$trx_poin_jumlah', 
                        '$trx_poin_tanggal')");

            //UPDATE tbl_mst_poin
            $db_arifahpulsa_api->query("UPDATE tbl_mst_poin set 
                                mst_poin_jumlah=mst_poin_jumlah + '$trx_poin_jumlah'
                                where
                                mst_poin_user_kode='$mst_user_kode'");

            //INSERT KE tbl_mst_inbox
            $db_arifahpulsa_api->query("insert into tbl_mst_inbox (
                        mst_inbox_kode, 
                        mst_inbox_user_kode, 
                        mst_inbox_jenis, 
                        mst_inbox_judul, 
                        mst_inbox_isi,
                        mst_inbox_tanggal,
                        mst_inbox_jangka_waktu,
                        mst_inbox_status) values (
                        '$mst_inbox_kode', 
                        '$mst_user_kode', 
                        'Teks',
                        '" . str_replace("'", "\'", $notifikasi_judul) . "',
                        '" . str_replace("'", "\'", $notifikasi_isi) . "',
                        '$trx_poin_tanggal',
                        '1',
                        '0')");

            //KIRIM NOTIFIKASI
            $title = $notifikasi_judul;
            $body =  strip_tags($notifikasi_isi);
            firebase_notification($title, $body, $mst_user_firebase);

            $data['poin_status'] = '0';
            echo json_encode($data);
        } else {
            $data['poin_status'] = '1';
            echo json_encode($data);
        }
    }
}
