<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Referral_transaksi extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model('Model_referral_transaksi', 'referral_transaksi');
        return true;
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('referral_transaksi');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Referral Transaksi';

        $this->template->load('includes/header', 'view_referral_transaksi', $data);
    }

    function aksi_referral()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('referral_transaksi');

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        if (strlen($txt_cari) > 0) {
            $list = $this->referral_transaksi->get_datatables_cari($txt_cari);
        } else {
            $list = $this->referral_transaksi->get_datatables_tanggal($tanggal_awal, $tanggal_akhir);
        }

        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->trx_bonus_kode;
            $row[] = $field->trx_bonus_user_kode;
            $row[] = $field->mst_user_nama_lengkap;
            $row[] = $field->trx_bonus_nama;
            $row[] = $field->trx_bonus_poin;
            $row[] = number_format($field->trx_bonus_admin, 0, ',', '.');
            $row[] = number_format($field->trx_bonus_harga, 0, ',', '.');
            $row[] = $field->trx_bonus_notasi;
            $row[] = $field->trx_bonus_keterangan;
            $row[] = date("d M Y H:i:s", strtotime($field->trx_bonus_tanggal));
            $data[] = $row;
        }

        if (strlen($txt_cari) > 0) {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->referral_transaksi->count_all_cari($txt_cari),
                "recordsFiltered" => $this->referral_transaksi->count_filtered_cari($txt_cari),
                "data" => $data,
            );
        } else {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->referral_transaksi->count_all_tanggal($tanggal_awal, $tanggal_akhir),
                "recordsFiltered" => $this->referral_transaksi->count_filtered_tanggal($tanggal_awal, $tanggal_akhir),
                "data" => $data,
            );
        }

        echo json_encode($output);
    }
}
