<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Saldo_bank extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_bank');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Bank Otomatis';

        $this->template->load('includes/header', 'view_saldo_bank', $data);
    }

    function aksi_data()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_bank');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url_mst_deposit_icon = 'http://141.11.241.178/arifahpulsa/admin/assets/upload/data-bank/';

        $query = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_deposit 
                                          ORDER BY mst_deposit_id ASC ");

        echo "<table id='example1' class='table table-bordered table-striped'>";
        echo    "<thead>
                    <tr>
                        <th>No</th>
                        <th>AKSI</th>
                        <th>STATUS</th>
                        <th>KODE</th>
                        <th>NAMA</th>
                        <th>ICON</th>
                        <th>ADMIN</th>
                        <th>PERSEN</th>
                    </tr>
                </thead
                <tbody>";

        $no = 1;
        foreach ($query->result() as $row) {
            if ($row->mst_deposit_status == '0') {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_deposit_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_tidak_aktif('" . $row->mst_deposit_kode . "')>SET TIDAK AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>AKTIF</div>";
            } else {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_deposit_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $row->mst_deposit_kode . "')>SET AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>TIDAK AKTIF</div>";
            }


            echo        "<tr>";
            echo            "<td>" . $no++ . "</td>";
            echo            "<td>$aksi </td>";
            echo            "<td id='tbl_mst_deposit_status'>$status</td>";
            echo            "<td id='tbl_mst_deposit_kode'>$row->mst_deposit_kode</td>";
            echo            "<td id='tbl_mst_deposit_nama'>$row->mst_deposit_nama</td>";
            echo            "<td id='tbl_mst_deposit_icon'><img src='$url_mst_deposit_icon" . "$row->mst_deposit_icon' class='rounded' alt='$row->mst_deposit_icon' style='width:70;height:70px;text-align:center'></td>";
            echo            "<td id='tbl_mst_deposit_admin'>$row->mst_deposit_admin</td> ";
            echo            "<td id='tbl_mst_deposit_persen'>$row->mst_deposit_persen</td>";
            echo        "</tr>";
        }
        echo        "</tbody>";
        echo    "</table>";
        echo "<script>
              
                $(document).ready(function () {
                    var table = $('#example1').DataTable({
                        lengthChange : true, 
                        autoWidth: true,
                        paging: true,
                        buttons: ['copy', 'print'],
                    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                
                  
                });
                
            </script>";
    }

    function aksi_edit()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_bank');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_deposit_kode = $this->input->post("mst_deposit_kode");
        $mst_deposit_nama = $this->input->post("mst_deposit_nama");
        $mst_deposit_admin = $this->input->post("mst_deposit_admin");
        $mst_deposit_persen = $this->input->post("mst_deposit_persen");

        //UPLOAD GAMBAR
        $config['upload_path'] = 'assets/upload/data-bank/';
        $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
        $config['remove_spaces'] = TRUE;
        $config['overwrite'] = TRUE;
        $config['max_size'] = '20000';
        $config['file_name'] = 'KTG-' . $mst_deposit_kode . "-" . rand(0, 999);

        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $this->upload->data();
        if ($this->upload->do_upload('mst_deposit_icon')) {
            $img_foto = $this->upload->data();
            $mst_deposit_icon = $img_foto['file_name'];
            $db_arifahpulsa_api->query("UPDATE tbl_mst_deposit set
                                        mst_deposit_nama='" . str_replace("'", "\'", $mst_deposit_nama) . "',
                                        mst_deposit_icon='$mst_deposit_icon',
                                        mst_deposit_admin='$mst_deposit_admin',
                                        mst_deposit_persen='" . str_replace("'", "\'", $mst_deposit_persen) . "'
                                        where  mst_deposit_kode='$mst_deposit_kode'");
        } else {
            $db_arifahpulsa_api->query("UPDATE tbl_mst_deposit set
                                        mst_deposit_nama='" . str_replace("'", "\'", $mst_deposit_nama) . "',
                                        mst_deposit_admin='$mst_deposit_admin',
                                        mst_deposit_persen='" . str_replace("'", "\'", $mst_deposit_persen) . "'
                                        where mst_deposit_kode='$mst_deposit_kode'");
        }

        $data['edit_status'] = '0';
        echo json_encode($data);
    }

    function aksi_tambah()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_bank');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_deposit_kode = $this->input->post("mst_deposit_kode");
        $mst_deposit_nama = $this->input->post("mst_deposit_nama");
        $mst_deposit_admin = $this->input->post("mst_deposit_admin");
        $mst_deposit_persen = $this->input->post("mst_deposit_persen");

        $query = $db_arifahpulsa_api->query("SELECT * from tbl_mst_deposit where mst_deposit_kode='$mst_deposit_kode'");

        if ($query->num_rows() > 0) {
            $data['tambah_status'] = '1';
            echo json_encode($data);
        } else {

            //UPLOAD GAMBAR
            $config['upload_path'] = 'assets/upload/data-bank/';
            $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
            $config['remove_spaces'] = TRUE;
            $config['overwrite'] = TRUE;
            $config['max_size'] = '20000';
            $config['file_name'] = 'KTG-' . $mst_deposit_kode;

            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->data();
            if ($this->upload->do_upload('mst_deposit_icon')) {
                $img_foto = $this->upload->data();
                $mst_deposit_icon = $img_foto['file_name'];
            } else {
                $mst_deposit_icon = "no_image.png";
            }

            $db_arifahpulsa_api->query("insert into tbl_mst_deposit (
                                mst_deposit_kode,
								mst_deposit_nama, 
                                mst_deposit_icon, 
                                mst_deposit_admin,
								mst_deposit_persen,
                                mst_deposit_status) values (
                                '$mst_deposit_kode', 
							    '" . str_replace("'", "\'", $mst_deposit_nama) . "',
								'$mst_deposit_icon', 
								'$mst_deposit_admin', 
                                '" . str_replace("'", "\'", $mst_deposit_persen) . "',
                                '0')");
            $data['tambah_status'] = '0';
            echo json_encode($data);
        }
    }

    function aksi_hapus($mst_deposit_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_bank');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("DELETE from tbl_mst_deposit where mst_deposit_kode='$mst_deposit_kode'");
    }

    function aksi_tidak_aktif($mst_deposit_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_bank');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_deposit set
                                        mst_deposit_status='1'
                                        where  mst_deposit_kode='$mst_deposit_kode'");
    }

    function aksi_aktif($mst_deposit_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('saldo_bank');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_deposit set
                                        mst_deposit_status='0'
                                        where  mst_deposit_kode='$mst_deposit_kode'");
    }
}
