<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Transfer extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model('Model_transfer', 'transfer');
        return true;
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transfer');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Transaksi Transfer';

        $this->template->load('includes/header', 'view_transfer', $data);
    }

    function aksi_transfer()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transfer');

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        if (strlen($txt_cari) > 0) {
            $list = $this->transfer->get_datatables_cari($txt_cari);
        } else {
            $list = $this->transfer->get_datatables_tanggal($tanggal_awal, $tanggal_akhir);
        }


        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->trx_transfer_kode;
            $row[] = $field->trx_transfer_user_kode;
            $row[] = $field->mst_user_nama_lengkap;
            $row[] = $field->trx_transfer_tujuan_nomor;
            $row[] = $field->trx_transfer_tujuan_nama;
            $row[] = number_format($field->trx_transfer_admin, 0, ',', '.');
            $row[] = number_format($field->trx_transfer_jumlah, 0, ',', '.');
            $row[] = date("d M Y H:i:s", strtotime($field->trx_transfer_tanggal));
            $row[] = $field->trx_transfer_keterangan;
            $data[] = $row;
        }

        if (strlen($txt_cari) > 0) {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->transfer->count_all_cari($txt_cari),
                "recordsFiltered" => $this->transfer->count_filtered_cari($txt_cari),
                "data" => $data,
            );
        } else {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->transfer->count_all_tanggal($tanggal_awal, $tanggal_akhir),
                "recordsFiltered" => $this->transfer->count_filtered_tanggal($tanggal_awal, $tanggal_akhir),
                "data" => $data,
            );
        }

        echo json_encode($output);
    }
}
