<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class User extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->library('pagination');
        $this->load->model('Model_user', 'user');
        return true;
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('user');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'User';

        $this->template->load('includes/header', 'view_user', $data);
    }


    function aksi_statistik()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('user');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        //AKTIF
        if (strlen($txt_cari) > 0) {
            $aktif = $db_arifahpulsa_api->query("SELECT count(mst_user_kode) as statistik_aktif_jumlah from tbl_mst_user
                                        where
                                        mst_user_status='0' and
                                        mst_user_kode LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='0' and
                                        mst_user_nama_lengkap LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='0' and
                                        mst_user_nomor_hp LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='0' and
                                        mst_user_email LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='0' and
                                        mst_user_tipe LIKE '%$txt_cari%'");
        } else {
            $aktif = $db_arifahpulsa_api->query("SELECT count(mst_user_kode) as statistik_aktif_jumlah from tbl_mst_user
                                        where mst_user_tanggal_daftar BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and mst_user_status='0'");
        }

        if ($aktif->num_rows() > 0) {
            foreach ($aktif->result() as $row) {
                $data['statistik_aktif_jumlah'] = number_format($row->statistik_aktif_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_aktif_jumlah'] = '0';
        }

        //BEKUKAN
        if (strlen($txt_cari) > 0) {
            $bekukan = $db_arifahpulsa_api->query("SELECT count(mst_user_kode) as statistik_bekukan_jumlah from tbl_mst_user
                                        where
                                        mst_user_status='1' and
                                        mst_user_kode LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='1' and
                                        mst_user_nama_lengkap LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='1' and
                                        mst_user_nomor_hp LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='1' and
                                        mst_user_email LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='1' and
                                        mst_user_tipe LIKE '%$txt_cari%'");
        } else {
            $bekukan = $db_arifahpulsa_api->query("SELECT count(mst_user_kode) as statistik_bekukan_jumlah from tbl_mst_user
                                        where mst_user_tanggal_daftar BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and mst_user_status='1'");
        }

        if ($bekukan->num_rows() > 0) {
            foreach ($bekukan->result() as $row) {
                $data['statistik_bekukan_jumlah'] = number_format($row->statistik_bekukan_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_bekukan_jumlah'] = '0';
        }


        //BLOKIR
        if (strlen($txt_cari) > 0) {
            $blokir = $db_arifahpulsa_api->query("SELECT count(mst_user_kode) as statistik_blokir_jumlah from tbl_mst_user
                                        where
                                        mst_user_status='2' and
                                        mst_user_kode LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='2' and
                                        mst_user_nama_lengkap LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='2' and
                                        mst_user_nomor_hp LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='2' and
                                        mst_user_email LIKE '%$txt_cari%'
                                        OR
                                        mst_user_status='2' and
                                        mst_user_tipe LIKE '%$txt_cari%'");
        } else {
            $blokir = $db_arifahpulsa_api->query("SELECT count(mst_user_kode) as statistik_blokir_jumlah from tbl_mst_user
                                        where mst_user_tanggal_daftar BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'
                                        and mst_user_status='2'");
        }

        if ($blokir->num_rows() > 0) {
            foreach ($blokir->result() as $row) {
                $data['statistik_blokir_jumlah'] = number_format($row->statistik_blokir_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_blokir_jumlah'] = '0';
        }

        //SEMUA
        if (strlen($txt_cari) > 0) {
            $semua = $db_arifahpulsa_api->query("SELECT count(mst_user_kode) as statistik_semua_jumlah from tbl_mst_user
                                        where
                                        mst_user_kode LIKE '%$txt_cari%'
                                        OR
                                        mst_user_nama_lengkap LIKE '%$txt_cari%'
                                        OR
                                        mst_user_nomor_hp LIKE '%$txt_cari%'
                                        OR
                                        mst_user_email LIKE '%$txt_cari%'
                                        OR
                                        mst_user_tipe LIKE '%$txt_cari%'");
        } else {
            $semua = $db_arifahpulsa_api->query("SELECT count(mst_user_kode) as statistik_semua_jumlah from tbl_mst_user
                                        where mst_user_tanggal_daftar BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'");
        }

        if ($semua->num_rows() > 0) {
            foreach ($semua->result() as $row) {
                $data['statistik_semua_jumlah'] = number_format($row->statistik_semua_jumlah, 0, ',', '.');
            }
        } else {
            $data['statistik_semua_jumlah'] = '0';
        }

        echo json_encode($data);
    }

    function aksi_user()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('user');

        $tanggal_awal = $this->input->post("startDate");
        $tanggal_akhir = $this->input->post("endDate");
        $txt_cari = $this->input->post("txt_cari");

        if (strlen($txt_cari) > 0) {
            $list = $this->user->get_datatables_cari($txt_cari);
        } else {
            $list = $this->user->get_datatables_tanggal($tanggal_awal, $tanggal_akhir);
        }


        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();

            //STATUS
            if ($field->mst_user_status == '0') {
                $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_notifikasi_modal(this)>KIRIM NOTIFIKASI</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_bekukan('" . $field->mst_user_kode . "')>SET KE BEKUKAN</a>
                            <a class='dropdown-item' onclick=aksi_blokir('" . $field->mst_user_kode . "')>SET KE TIDAK AKTIF</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $field->mst_user_kode . "')>HAPUS</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>Aktif</div>";
            } else  if ($field->mst_user_status == '1') {
                $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_notifikasi_modal(this)>KIRIM NOTIFIKASI</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $field->mst_user_kode . "')>SET KE AKTIF</a>
                            <a class='dropdown-item' onclick=aksi_blokir('" . $field->mst_user_kode . "')>SET KE TIDAK AKTIF</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $field->mst_user_kode . "')>HAPUS</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-warning'>Bekukan</div>";
            } else {
                $aksi = "<div  style='position: relative;float: none;' class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_notifikasi_modal(this)>KIRIM NOTIFIKASI</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $field->mst_user_kode . "')>SET KE AKTIF</a>
                            <a class='dropdown-item' onclick=aksi_bekukan('" . $field->mst_user_kode . "')>SET KE BEKUKAN</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $field->mst_user_kode . "')>HAPUS</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>Blokir</div>";
            }


            $row[] = $no;
            $row[] = $aksi;
            $row[] = $status;
            $row[] = $field->mst_user_kode;
            $row[] = $field->mst_user_nama_lengkap;
            $row[] = $field->mst_user_nomor_hp;
            $row[] = $field->mst_user_email;
            $row[] = $field->mst_user_tipe;
            $row[] = $field->mst_user_referal_kode;
            $row[] = $field->mst_user_referal_bonus;
            $row[] = $field->mst_user_upline;
            $row[] = $field->mst_user_firebase;
            $row[] = $field->mst_user_token;
            $row[] = $field->mst_user_zona_waktu;
            $row[] = date("d M Y H:i:s", strtotime($field->mst_user_tanggal_daftar));
            $row[] = date("d M Y H:i:s", strtotime($field->mst_user_terkhir_aktif));
            $data[] = $row;
        }

        if (strlen($txt_cari) > 0) {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->user->count_all_cari($txt_cari),
                "recordsFiltered" => $this->user->count_filtered_cari($txt_cari),
                "data" => $data,
            );
        } else {
            $output = array(
                "draw" => $_POST['draw'],
                "recordsTotal" => $this->user->count_all_tanggal($tanggal_awal, $tanggal_akhir),
                "recordsFiltered" => $this->user->count_filtered_tanggal($tanggal_awal, $tanggal_akhir),
                "data" => $data,
            );
        }

        echo json_encode($output);
    }

    function aksi_notifikasi()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('transaksi/transaksi_gopay');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_inbox_kode =  "INBOX-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
        $mst_inbox_tanggal = date('Y-m-d H:i:s');
        $notifikasi_user_kode = $this->input->post("notifikasi_user_kode");
        $notifikasi_judul = $this->input->post("notifikasi_judul");
        $notifikasi_isi = $this->input->post("notifikasi_isi");

        //PANGGIL USER
        $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$notifikasi_user_kode'");
        if ($user->num_rows() > 0) {
            foreach ($user->result() as $row) {
                $mst_user_firebase = $row->mst_user_firebase;
            }

            //INSERT KE tbl_mst_inbox
            $db_arifahpulsa_api->query("insert into tbl_mst_inbox (
                        mst_inbox_kode, 
                        mst_inbox_user_kode, 
                        mst_inbox_jenis, 
                        mst_inbox_judul, 
                        mst_inbox_isi,
                        mst_inbox_tanggal,
                        mst_inbox_jangka_waktu,
                        mst_inbox_status) values (
                        '$mst_inbox_kode', 
                        '$notifikasi_user_kode', 
                        'Teks',
                        '" . str_replace("'", "\'", $notifikasi_judul) . "',
                        '" . str_replace("'", "\'", $notifikasi_isi) . "',
                        '$mst_inbox_tanggal',
                        '1',
                        '0')");

            //KIRIM NOTIFIKASI
            $title = $notifikasi_judul;
            $body =  strip_tags($notifikasi_isi);
            firebase_notification($title, $body, $mst_user_firebase);

            $data['notifikasi_status'] = '0';
            echo json_encode($data);
        } else {
            $data['notifikasi_status'] = '1';
            echo json_encode($data);
        }
    }

    function aksi_aktif($mst_user_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('user/edit');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        //UPDATE tbl_mst_user
        $db_arifahpulsa_api->query("UPDATE tbl_mst_user set 
                        mst_user_status='0'
                        where
                        mst_user_kode='$mst_user_kode'");

        //PANGGIL USER
        $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$mst_user_kode'");
        if ($user->num_rows() > 0) {
            foreach ($user->result() as $row) {
                $mst_user_firebase = $row->mst_user_firebase;
            }

            //KIRIM NOTIFIKASI
            $title = 'Akun aktif';
            $body =  strip_tags('Akun kamu telah aktif, silahkan gunakan Arifah Pulsa sesuai dengan kebutuhan kamu');
            firebase_notification($title, $body, $mst_user_firebase);
        }

        $data['user_status'] = '0';
        echo json_encode($data);
    }

    function aksi_bekukan($mst_user_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('user/edit');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        //UPDATE tbl_mst_user
        $db_arifahpulsa_api->query("UPDATE tbl_mst_user set 
                        mst_user_status='1'
                        where
                        mst_user_kode='$mst_user_kode'");

        //PANGGIL USER
        $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$mst_user_kode'");
        if ($user->num_rows() > 0) {
            foreach ($user->result() as $row) {
                $mst_user_firebase = $row->mst_user_firebase;
            }

            //KIRIM NOTIFIKASI
            $title = 'Akun dibekukan';
            $body =  strip_tags('Akun kamu dibekukan untuk sementara waktu karena terdeteksi melakukan pelanggan. Tunggu hingga kami selesai me-review akun kamu!');
            firebase_notification($title, $body, $mst_user_firebase);
        }

        $data['user_status'] = '0';
        echo json_encode($data);
    }

    function aksi_blokir($mst_user_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('user/edit');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        //UPDATE tbl_mst_user
        $db_arifahpulsa_api->query("UPDATE tbl_mst_user set 
                        mst_user_status='2'
                        where
                        mst_user_kode='$mst_user_kode'");

        //PANGGIL USER
        $user = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$mst_user_kode'");
        if ($user->num_rows() > 0) {
            foreach ($user->result() as $row) {
                $mst_user_firebase = $row->mst_user_firebase;
            }

            //KIRIM NOTIFIKASI
            $title = 'Akun diblokir';
            $body =  strip_tags('Akun kamu diblokir untuk karena terdeteksi melakukan pelanggan. Jika ada pertanyaan silahkan menghubungi customer service Arifah Pulsa.');
            firebase_notification($title, $body, $mst_user_firebase);
        }

        $data['user_status'] = '0';
        echo json_encode($data);
    }

    function aksi_hapus($mst_user_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('user/hapus');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        //HAPUS tbl_mst_user
        $db_arifahpulsa_api->query("DELETE from tbl_mst_user where mst_user_kode='$mst_user_kode'");

        $data['user_status'] = '0';
        echo json_encode($data);
    }
}
