<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Kategori_internet extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_internet');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Kategori Game';

        $this->template->load('includes/header', 'kategori/view_kategori_internet', $data);
    }

    function aksi_data()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_internet');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url_ktg_internet_icon = 'http://141.11.241.178/arifahpulsa/admin/assets/upload/data-kategori/';

        $query = $db_arifahpulsa_api->query("SELECT * FROM tbl_ktg_internet 
                                          ORDER BY ktg_internet_urutan ASC ");

        echo "<table id='example1' class='table table-bordered table-striped'>";
        echo    "<thead>
                    <tr>
                        <th>No</th>
                        <th>AKSI</th>
                        <th>STATUS</th>
                        <th>KODE</th>
                        <th>NAMA</th>
                        <th>ICON</th>
                        <th>URUTAN</th>
                        <th>KETERANGAN</th>
                        <th>NOTASI</th>
                    </tr>
                </thead
                <tbody>";

        $no = 1;
        foreach ($query->result() as $row) {
            if ($row->ktg_internet_status == '0') {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->ktg_internet_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_tidak_aktif('" . $row->ktg_internet_kode . "')>SET TIDAK AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>AKTIF</div>";
            } else {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->ktg_internet_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $row->ktg_internet_kode . "')>SET AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>TIDAK AKTIF</div>";
            }


            echo        "<tr>";
            echo            "<td>" . $no++ . "</td>";
            echo            "<td>$aksi </td>";
            echo            "<td id='tbl_ktg_internet_status'>$status</td>";
            echo            "<td id='tbl_ktg_internet_kode'>$row->ktg_internet_kode</td>";
            echo            "<td id='tbl_ktg_internet_nama'>$row->ktg_internet_nama</td>";
            echo            "<td id='tbl_ktg_internet_icon'><img src='$url_ktg_internet_icon" . "$row->ktg_internet_icon' class='rounded' alt='$row->ktg_internet_icon' style='width:70;height:70px;text-align:center'></td>";
            echo            "<td id='tbl_ktg_internet_urutan'>$row->ktg_internet_urutan</td> ";
            echo            "<td id='tbl_ktg_internet_keterangan'>$row->ktg_internet_keterangan</td>";
            echo            "<td id='tbl_ktg_internet_notasi'>$row->ktg_internet_notasi</td> ";
            echo        "</tr>";
        }
        echo        "</tbody>";
        echo    "</table>";
        echo "<script>
              
                $(document).ready(function () {
                    var table = $('#example1').DataTable({
                        lengthChange : true, 
                        autoWidth: true,
                        paging: true,
                        buttons: ['copy', 'print'],
                    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                
                  
                });
                
            </script>";
    }

    function aksi_reload()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_internet');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url = "https://api.digiflazz.com/v1/price-list";

        $header = array(
            'Content-Type: text/plain',
        );

        $data = array(
            'cmd' => 'pasca',
            'username' => $this->config->item('digiflazz_api_username'),
            'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . 'pricelist')
        );

        $json = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($result, true)['data'];

        foreach ($response as $data) {
            //DIGIFLAZZ
            $buyer_sku_code = $data['buyer_sku_code'];
            $price = $data['price'];
            $seller_product_status = $data['seller_product_status'];
            $buyer_product_status = $data['buyer_product_status'];

            if ($seller_product_status === true && $buyer_product_status === true) {
                //AKTIF
                $tbl_ktg_internet[] = array(
                    'ktg_internet_kode' => $buyer_sku_code,
                    'ktg_internet_keterangan' =>  'Nomor pelanggan dibutuhkan untuk melakukan transaksi',
                    'ktg_internet_status' =>  '0'
                );
            } else {
                //TIDAK AKTIF
                $tbl_ktg_internet[] = array(
                    'ktg_internet_kode' => $buyer_sku_code,
                    'ktg_internet_keterangan' =>  'Kategori internet ini tidak aktif karena sedang maintenance, silahkan cek secara berkala untuk melihat status terkini.',
                    'ktg_internet_status' =>  '1'
                );
            }
        }
        //UPDATE
        $db_arifahpulsa_api->update_batch('tbl_ktg_internet', $tbl_ktg_internet, 'ktg_internet_kode');
    }

    function aksi_edit()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_internet');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $ktg_internet_kode = $this->input->post("ktg_internet_kode");
        $ktg_internet_nama = $this->input->post("ktg_internet_nama");
        $ktg_internet_urutan = $this->input->post("ktg_internet_urutan");
        $ktg_internet_keterangan = $this->input->post("ktg_internet_keterangan");
        $ktg_internet_notasi = $this->input->post("ktg_internet_notasi");

        //UPLOAD GAMBAR
        $config['upload_path'] = 'assets/upload/data-kategori/';
        $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
        $config['remove_spaces'] = TRUE;
        $config['overwrite'] = TRUE;
        $config['max_size'] = '20000';
        $config['file_name'] = 'KTG-' . $ktg_internet_kode . "-" . rand(0, 999);

        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $this->upload->data();
        if ($this->upload->do_upload('ktg_internet_icon')) {
            $img_foto = $this->upload->data();
            $ktg_internet_icon = $img_foto['file_name'];
            $db_arifahpulsa_api->query("UPDATE tbl_ktg_internet set
                                        ktg_internet_nama='" . str_replace("'", "\'", $ktg_internet_nama) . "',
                                        ktg_internet_icon='$ktg_internet_icon',
                                        ktg_internet_urutan='$ktg_internet_urutan',
                                        ktg_internet_keterangan='" . str_replace("'", "\'", $ktg_internet_keterangan) . "',
                                        ktg_internet_notasi='" . str_replace("'", "\'", $ktg_internet_notasi) . "'
                                        where  ktg_internet_kode='$ktg_internet_kode'");
        } else {
            $db_arifahpulsa_api->query("UPDATE tbl_ktg_internet set
                                        ktg_internet_nama='" . str_replace("'", "\'", $ktg_internet_nama) . "',
                                        ktg_internet_urutan='$ktg_internet_urutan',
                                        ktg_internet_keterangan='" . str_replace("'", "\'", $ktg_internet_keterangan) . "',
                                        ktg_internet_notasi='" . str_replace("'", "\'", $ktg_internet_notasi) . "'
                                        where ktg_internet_kode='$ktg_internet_kode'");
        }

        $data['edit_status'] = '0';
        echo json_encode($data);
    }

    function aksi_tambah()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_internet');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $ktg_internet_kode = $this->input->post("ktg_internet_kode");
        $ktg_internet_nama = $this->input->post("ktg_internet_nama");
        $ktg_internet_urutan = $this->input->post("ktg_internet_urutan");
        $ktg_internet_keterangan = $this->input->post("ktg_internet_keterangan");
        $ktg_internet_notasi = $this->input->post("ktg_internet_notasi");

        $query = $db_arifahpulsa_api->query("SELECT * from tbl_ktg_internet where ktg_internet_kode='$ktg_internet_kode'");

        if ($query->num_rows() > 0) {
            $data['tambah_status'] = '1';
            echo json_encode($data);
        } else {

            //UPLOAD GAMBAR
            $config['upload_path'] = 'assets/upload/data-kategori/';
            $config['allowed_types'] = 'jpg|png|JPG|JPEG|webp|WEBP|PNG';
            $config['remove_spaces'] = TRUE;
            $config['overwrite'] = TRUE;
            $config['max_size'] = '20000';
            $config['file_name'] = 'KTG-' . $ktg_internet_kode;

            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            $this->upload->data();
            if ($this->upload->do_upload('ktg_internet_icon')) {
                $img_foto = $this->upload->data();
                $ktg_internet_icon = $img_foto['file_name'];
            } else {
                $ktg_internet_icon = "no_image.png";
            }

            $db_arifahpulsa_api->query("insert into tbl_ktg_internet (
                                ktg_internet_kode,
								ktg_internet_nama, 
                                ktg_internet_icon, 
                                ktg_internet_urutan,
								ktg_internet_keterangan, 
								ktg_internet_notasi) values (
                                '$ktg_internet_kode', 
							    '" . str_replace("'", "\'", $ktg_internet_nama) . "',
								'$ktg_internet_icon', 
								'$ktg_internet_urutan', 
								'" . str_replace("'", "\'", $ktg_internet_keterangan) . "',
                                '" . str_replace("'", "\'", $ktg_internet_notasi) . "')");
            $data['tambah_status'] = '0';
            echo json_encode($data);
        }
    }

    function aksi_hapus($ktg_internet_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_internet');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("DELETE from tbl_ktg_internet where ktg_internet_kode='$ktg_internet_kode'");
    }

    function aksi_tidak_aktif($ktg_internet_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_internet');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_ktg_internet set
                                        ktg_internet_status='1'
                                        where  ktg_internet_kode='$ktg_internet_kode'");
    }

    function aksi_aktif($ktg_internet_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('kategori/kategori_internet');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_ktg_internet set
                                        ktg_internet_status='0'
                                        where  ktg_internet_kode='$ktg_internet_kode'");
    }
}
