<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Master_indomaret extends CI_Controller
{
    /**
     * This is default constructor of the class
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_indomaret');
        $data['title'] = 'arifahpulsa';
        $data['halaman'] = 'Master Indomaret';

        $this->template->load('includes/header', 'master/view_master_indomaret', $data);
    }

    function aksi_data()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_indomaret');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $query = $db_arifahpulsa_api->query("SELECT * FROM tbl_mst_indomaret 
                                          ORDER BY mst_indomaret_urutan ASC ");

        echo "<table id='example1' class='table table-bordered table-striped'>";
        echo    "<thead>
                    <tr>
                        <th>No</th>
                        <th>AKSI</th>
                        <th>STATUS</th>
                        <th>KODE</th>
                        <th>NAMA</th>
                        <th>ADMIN</th>
                        <th>HARGA</th>
                        <th>JUAL</th>
                        <th>POIN</th>
                        <th>KETERANGAN</th>
                        <th>NOTASI</th>
                        <th>URUTAN</th>
                    </tr>
                </thead
                <tbody>";

        $no = 1;
        foreach ($query->result() as $row) {
            if ($row->mst_indomaret_status == '0') {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                            <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_indomaret_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_tidak_aktif('" . $row->mst_indomaret_kode . "')>SET TIDAK AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-success'>AKTIF</div>";
            } else {
                $aksi = "<div class='btn-group'>
                        <button type='button' class='btn btn-danger'>PILIH</button>
                        <button type='button' class='btn btn-danger dropdown-toggle dropdown-icon' data-toggle='dropdown'>
                        <span class='sr-only'>Toggle Dropdown</span>
                        <div style='position: relative;float: none;' class='dropdown-menu' role='menu'>
                            <a class='dropdown-item' onclick=aksi_edit_modal(this)>EDIT</a>
                           <a class='dropdown-item' onclick=aksi_hapus('" . $row->mst_indomaret_kode . "')>HAPUS</a>
                            <div class='dropdown-divider'></div>
                            <a class='dropdown-item' onclick=aksi_aktif('" . $row->mst_indomaret_kode . "')>SET AKTIF</a>
                        </div>
                        </button>
                    </div>";
                $status = "<div class='btn btn-danger'>TIDAK AKTIF</div>";
            }


            echo        "<tr>";
            echo            "<td>" . $no++ . "</td>";
            echo            "<td>$aksi </td>";
            echo            "<td id='tbl_mst_indomaret_status'>$status</td>";
            echo            "<td id='tbl_mst_indomaret_kode'>$row->mst_indomaret_kode</td>";
            echo            "<td id='tbl_mst_indomaret_nama'>$row->mst_indomaret_nama</td>";
            echo            "<td id='tbl_mst_indomaret_admin'>" . number_format($row->mst_indomaret_admin, 0, ',', '.') . "</td> ";
            echo            "<td id='tbl_mst_indomaret_harga'>" . number_format($row->mst_indomaret_harga, 0, ',', '.') . "</td> ";
            echo            "<td id='tbl_mst_indomaret_total'>" . number_format($row->mst_indomaret_admin + $row->mst_indomaret_harga, 0, ',', '.') . "</td> ";
            echo            "<td id='tbl_mst_indomaret_poin'>$row->mst_indomaret_poin</td>";
            echo            "<td id='tbl_mst_indomaret_keterangan'>$row->mst_indomaret_keterangan</td> ";
            echo            "<td id='tbl_mst_indomaret_notasi'>$row->mst_indomaret_notasi</td>";
            echo            "<td id='tbl_mst_indomaret_urutan'>$row->mst_indomaret_urutan</td> ";
            echo        "</tr>";
        }
        echo        "</tbody>";
        echo    "</table>";
        echo "<script>
              
                $(document).ready(function () {
                    var table = $('#example1').DataTable({
                        lengthChange : true, 
                        autoWidth: true,
                        paging: true,
                        buttons: ['copy', 'print'],
                    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
                
                  
                });
                
            </script>";
    }

    function aksi_reload()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_indomaret');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $url = "https://api.digiflazz.com/v1/price-list";

        $header = array(
            'Content-Type: text/plain',
        );

        $data = array(
            'cmd' => 'prepaid',
            'username' => $this->config->item('digiflazz_api_username'),
            'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . 'pricelist')
        );

        $json = json_encode($data);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($result, true)['data'];

        foreach ($response as $data) {
            //DIGIFLAZZ
            $buyer_sku_code = $data['buyer_sku_code'];
            $price = $data['price'];
            $seller_product_status = $data['seller_product_status'];
            $buyer_product_status = $data['buyer_product_status'];

            if ($seller_product_status === true && $buyer_product_status === true) {
                //AKTIF
                $tbl_mst_indomaret[] = array(
                    'mst_indomaret_kode' => $buyer_sku_code,
                    'mst_indomaret_harga' =>  $price,
                    'mst_indomaret_status' =>  '0'
                );
            } else {
                //TIDAK AKTIF
                $tbl_mst_indomaret[] = array(
                    'mst_indomaret_kode' => $buyer_sku_code,
                    'mst_indomaret_harga' =>  $price,
                    'mst_indomaret_status' =>  '1'
                );
            }
        }
        //UPDATE
        $db_arifahpulsa_api->update_batch('tbl_mst_indomaret', $tbl_mst_indomaret, 'mst_indomaret_kode');
    }

    function aksi_edit()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_indomaret/edit');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_indomaret_kode = $this->input->post("mst_indomaret_kode");
        $mst_indomaret_nama = $this->input->post("mst_indomaret_nama");
        $mst_indomaret_keterangan = $this->input->post("mst_indomaret_keterangan");
        $mst_indomaret_notasi = $this->input->post("mst_indomaret_notasi");
        $mst_indomaret_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_indomaret_harga"));
        $mst_indomaret_admin = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_indomaret_admin"));
        $mst_indomaret_poin = $this->input->post("mst_indomaret_poin");
        $mst_indomaret_urutan = $this->input->post("mst_indomaret_urutan");

        $db_arifahpulsa_api->query("UPDATE tbl_mst_indomaret set
                                        mst_indomaret_nama='" . str_replace("'", "\'", $mst_indomaret_nama) . "',
                                        mst_indomaret_keterangan='" . str_replace("'", "\'", $mst_indomaret_keterangan) . "',
                                        mst_indomaret_notasi='" . str_replace("'", "\'", $mst_indomaret_notasi) . "',
                                        mst_indomaret_harga='$mst_indomaret_harga',
                                        mst_indomaret_admin='$mst_indomaret_admin',
                                        mst_indomaret_poin='$mst_indomaret_poin',
                                        mst_indomaret_urutan='$mst_indomaret_urutan'
                                        where  mst_indomaret_kode='$mst_indomaret_kode'");
    }

    function aksi_tambah()
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_indomaret/tambah');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $mst_indomaret_kode = $this->input->post("mst_indomaret_kode");
        $mst_indomaret_nama = $this->input->post("mst_indomaret_nama");
        $mst_indomaret_keterangan = $this->input->post("mst_indomaret_keterangan");
        $mst_indomaret_notasi = $this->input->post("mst_indomaret_notasi");
        $mst_indomaret_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_indomaret_harga"));
        $mst_indomaret_admin = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->input->post("mst_indomaret_admin"));
        $mst_indomaret_poin = $this->input->post("mst_indomaret_poin");
        $mst_indomaret_urutan = $this->input->post("mst_indomaret_urutan");

        $query = $db_arifahpulsa_api->query("SELECT * from tbl_mst_indomaret where mst_indomaret_kode='$mst_indomaret_kode'");

        if ($query->num_rows() > 0) {
            $data['tambah_status'] = '1';
            echo json_encode($data);
        } else {
            $db_arifahpulsa_api->query("insert into tbl_mst_indomaret (
                                mst_indomaret_kode,
								mst_indomaret_nama, 
								mst_indomaret_keterangan, 
								mst_indomaret_notasi, 
								mst_indomaret_harga,
								mst_indomaret_admin,
								mst_indomaret_poin,
								mst_indomaret_urutan) values (
                                '$mst_indomaret_kode', 
								'" . str_replace("'", "\'", $mst_indomaret_nama) . "', 
								'" . str_replace("'", "\'", $mst_indomaret_keterangan) . "',
								'" . str_replace("'", "\'", $mst_indomaret_notasi) . "',
								'$mst_indomaret_harga',
								'$mst_indomaret_admin', 
								'$mst_indomaret_poin', 
								'$mst_indomaret_urutan')");
            $data['tambah_status'] = '0';
            echo json_encode($data);
        }
    }

    function aksi_hapus($mst_indomaret_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_indomaret/hapus');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("DELETE from tbl_mst_indomaret where mst_indomaret_kode='$mst_indomaret_kode'");
    }

    function aksi_tidak_aktif($mst_indomaret_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_indomaret/edit');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_indomaret set
                                        mst_indomaret_status='1'
                                        where  mst_indomaret_kode='$mst_indomaret_kode'");
    }

    function aksi_aktif($mst_indomaret_kode)
    {
        $this->Model_squrity->getsqurity();
        $this->Model_squrity->cekmenu('master/master_indomaret/edit');

        $db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', TRUE);

        $db_arifahpulsa_api->query("UPDATE tbl_mst_indomaret set
                                        mst_indomaret_status='0'
                                        where  mst_indomaret_kode='$mst_indomaret_kode'");
    }
}
