<?php

class Model_user extends CI_Model
{

    var $column_order = array('mst_user_kode', 'mst_user_nama_lengkap', 'mst_user_email');
    var $column_search = array(
        'mst_user_kode', 'mst_user_nama_lengkap',
        'mst_user_nomor_hp',  'mst_user_email', 'mst_user_tipe', 'mst_user_status'
    );
    var $order = array('mst_user_tanggal_daftar' => 'asc');

    //FILTER BERDASARKAN TANGGAL
    private function _get_datatables_query_tanggal($tanggal_awal, $tanggal_akhir)
    {
        $this->load->database('db_arifahpulsa_api', true);
        $this->db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', true);

        $this->db_arifahpulsa_api->select("mst_user_kode,
                                        mst_user_nama_lengkap,mst_user_nomor_hp,
                                        mst_user_email,mst_user_tipe,mst_user_referal_kode,
                                        mst_user_referal_bonus,mst_user_upline,mst_user_firebase,
                                        mst_user_token,mst_user_zona_waktu,mst_user_tanggal_daftar,
                                        mst_user_terkhir_aktif,mst_user_status")
            ->from("tbl_mst_user")
            ->where("mst_user_tanggal_daftar BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'");

        $i = 0;
        foreach ($this->column_search as $item) // looping awal
        {
            if ($_POST['search']['value']) {
                if ($i === 0) {
                    $this->db_arifahpulsa_api->group_start();
                    $this->db_arifahpulsa_api->like($item, $_POST['search']['value']);
                } else {
                    $this->db_arifahpulsa_api->or_like($item, $_POST['search']['value']);
                }

                if (count($this->column_search) - 1 == $i)
                    $this->db_arifahpulsa_api->group_end();
            }
            $i++;
        }

        if (isset($_POST['order'])) {
            $this->db_arifahpulsa_api->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db_arifahpulsa_api->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables_tanggal($tanggal_awal, $tanggal_akhir)
    {
        $this->_get_datatables_query_tanggal($tanggal_awal, $tanggal_akhir);
        if ($_POST['length'] != -1) {
            $this->db_arifahpulsa_api->limit($_POST['length'], $_POST['start']);
            $query = $this->db_arifahpulsa_api->get();
        }
        return $query->result();
    }


    function count_filtered_tanggal($tanggal_awal, $tanggal_akhir)
    {
        $this->_get_datatables_query_tanggal($tanggal_awal, $tanggal_akhir);
        $query =  $this->db_arifahpulsa_api->get();
        return $query->num_rows();
    }

    public function count_all_tanggal($tanggal_awal, $tanggal_akhir)
    {
        $this->db_arifahpulsa_api->select("mst_user_kode,
                                        mst_user_nama_lengkap,mst_user_nomor_hp,
                                        mst_user_email,mst_user_tipe,mst_user_referal_kode,
                                        mst_user_referal_bonus,mst_user_upline,mst_user_firebase,
                                        mst_user_token,mst_user_zona_waktu,mst_user_tanggal_daftar,
                                        mst_user_terkhir_aktif,mst_user_status")
            ->from("tbl_mst_user")
            ->where("mst_user_tanggal_daftar BETWEEN '$tanggal_awal 00:00:00' AND '$tanggal_akhir 23:59:59'");
        return $this->db_arifahpulsa_api->count_all_results();
    }


    //FILTER BERDASARKAN PENCARIAN
    private function _get_datatables_query_cari($txt_cari)
    {
        $this->load->database('db_arifahpulsa_api', true);
        $this->db_arifahpulsa_api = $this->load->database('db_arifahpulsa_api', true);

        $this->db_arifahpulsa_api->select("mst_user_kode,
                                        mst_user_nama_lengkap,mst_user_nomor_hp,
                                        mst_user_email,mst_user_tipe,mst_user_referal_kode,
                                        mst_user_referal_bonus,mst_user_upline,mst_user_firebase,
                                        mst_user_token,mst_user_zona_waktu,mst_user_tanggal_daftar,
                                        mst_user_terkhir_aktif,mst_user_status")
            ->from("tbl_mst_user")
            ->where("mst_user_kode LIKE '%$txt_cari%'
                    OR
                    mst_user_nama_lengkap LIKE '%$txt_cari%'
                    OR
                    mst_user_nomor_hp LIKE '%$txt_cari%'
                    OR
                    mst_user_email LIKE '%$txt_cari%'
                    OR
                    mst_user_tipe LIKE '%$txt_cari%'");

        $i = 0;
        foreach ($this->column_search as $item) // looping awal
        {
            if ($_POST['search']['value']) {
                if ($i === 0) {
                    $this->db_arifahpulsa_api->group_start();
                    $this->db_arifahpulsa_api->like($item, $_POST['search']['value']);
                } else {
                    $this->db_arifahpulsa_api->or_like($item, $_POST['search']['value']);
                }

                if (count($this->column_search) - 1 == $i)
                    $this->db_arifahpulsa_api->group_end();
            }
            $i++;
        }

        if (isset($_POST['order'])) {
            $this->db_arifahpulsa_api->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->order)) {
            $order = $this->order;
            $this->db_arifahpulsa_api->order_by(key($order), $order[key($order)]);
        }
    }

    function get_datatables_cari($txt_cari)
    {
        $this->_get_datatables_query_cari($txt_cari);
        if ($_POST['length'] != -1) {
            $this->db_arifahpulsa_api->limit($_POST['length'], $_POST['start']);
            $query = $this->db_arifahpulsa_api->get();
        }
        return $query->result();
    }


    function count_filtered_cari($txt_cari)
    {
        $this->_get_datatables_query_cari($txt_cari);
        $query =  $this->db_arifahpulsa_api->get();
        return $query->num_rows();
    }

    public function count_all_cari($txt_cari)
    {
        $this->db_arifahpulsa_api->select("mst_user_kode,
                                        mst_user_nama_lengkap,mst_user_nomor_hp,
                                        mst_user_email,mst_user_tipe,mst_user_referal_kode,
                                        mst_user_referal_bonus,mst_user_upline,mst_user_firebase,
                                        mst_user_token,mst_user_zona_waktu,mst_user_tanggal_daftar,
                                        mst_user_terkhir_aktif,mst_user_status")
            ->from("tbl_mst_user")
            ->where("mst_user_kode LIKE '%$txt_cari%'
                    OR
                    mst_user_nama_lengkap LIKE '%$txt_cari%'
                    OR
                    mst_user_nomor_hp LIKE '%$txt_cari%'
                    OR
                    mst_user_email LIKE '%$txt_cari%'
                    OR
                    mst_user_tipe LIKE '%$txt_cari%'");
        return $this->db_arifahpulsa_api->count_all_results();
    }
}
