<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title> <?php echo $title; ?> </title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
  <link rel="icon" href="<?php echo $title; ?>">

  <style>
    body {
      background-color: #000;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 90vh;
    }

    .container {
      display: flex;
      justify-content: space-around;
      align-items: center;
      height: 100%;
    }

    .card {
      width: 500px;
      height: 500px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      margin: 5px;
      background-color: #1c1c1c;
      border-radius: 10px;
      box-shadow: 0 2px 5px rgba(0, 0, 0, 0.3);
      color: #fff;
      border: 1px solid #fff;
    }

    .card_transaksi {
      width: 600px;
      height: 500px;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      margin: 5px;
      background-color: #1c1c1c;
      box-shadow: 0 2px 5px rgba(0, 0, 0, 0.3);
      color: #fff;
    }

    .card_total_pendapatan {
      height: 100%;
      width: 100%;
      display: flex;
      margin-left: 10px;
      margin-right: 10px;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      background-color: #1c1c1c;
      color: #fff;
      border: 1px solid #fff;
    }

    .card_total_transaksi {
      height: 100%;
      width: 100%;
      display: flex;
      margin-left: 10px;
      margin-right: 10px;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      background-color: #1c1c1c;
      color: #fff;
      border: 1px solid #fff;
    }

    .card_total_saldo {
      height: 100%;
      width: 100%;
      display: flex;
      margin-left: 30px;
      margin-right: 30px;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      background-color: #1c1c1c;
      color: #fff;
      border: 1px solid #fff;
    }

    .user {
      background-image: linear-gradient(to bottom, #000, #000);
    }

    .transaksi {
      background-image: linear-gradient(to bottom, #000, #000);
      width: 100%;
    }

    h2 {
      font-size: 1em;
      margin: 0 0 10px 0;
    }

    p {
      font-size: 2em;
      font-weight: bold;
      margin: 0;
    }

    @keyframes counting {
      from {
        opacity: 0;
        transform: translateY(50px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }
  </style>

</head>

<body id="oke">
  <div class="container">
    <div class="card user">
      <h2>Pengguna</h2>
      <p id="transaksi_user">Loading...</p>
    </div>
    <div class="card_transaksi">
      <div class="card_total_pendapatan transaksi">
        <h2>Pendapatan</h2>
        <p id="transaksi_pendapatan">Loading...</p>
      </div>
      <div class="card_total_transaksi transaksi">
        <h2>Total Transaksi</h2>
        <p id="transaksi_jumlah">Loading...</p>
      </div>
      <div class="card_total_saldo transaksi">
        <h2>Saldo Pengguna</h2>
        <p id="transaksi_saldo">Loading...</p>
      </div>
    </div>

  </div>
</body>

</html>

<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    aksi_transaksi();
  });



  function aksi_transaksi() {
    $.ajax({
      type: 'POST',
      url: '<?php echo base_url() ?>monitor/aksi_transaksi/',
      success: function(data) {
        var obj = JSON.parse(data);
        var transaksi_user = obj.transaksi_user;
        var transaksi_pendapatan = obj.transaksi_pendapatan;
        var transaksi_jumlah = obj.transaksi_jumlah;
        var transaksi_saldo = obj.transaksi_saldo;

        document.getElementById("transaksi_user").innerHTML = obj.transaksi_user;
        document.getElementById("transaksi_pendapatan").innerHTML = obj.transaksi_pendapatan;
        document.getElementById("transaksi_jumlah").innerHTML = obj.transaksi_jumlah;
        document.getElementById("transaksi_saldo").innerHTML = obj.transaksi_saldo;

        setTimeout(aksi_transaksi, 5000);
      }
    })
  }
</script>