<div class="container-fluid">
    <div class="row">
        <div style="margin-bottom: 10px;" class="col-md-3">
            <input type="text" class="form-control col-md-12" id="transaksi_tanggal" placeholder="Pilih tanggal">
        </div>

        <div style="margin-bottom: 10px;" class="col-md-7">
            <input type="text" class="form-control col-md-12" id="txt_cari" placeholder="Cari kode transaksi, nama produk, status transaksi dan nomor tujuan">

        </div>

        <div style="margin-bottom: 10px;" class="col-md-2">
            <button type="button" id="btn_cari" class="btn btn-primary col-md-12">Cari</button>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box bg-gradient-success">
                <span class="info-box-icon"><i class="fas fa-chart-line"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Transaksi Sukses</span>
                    <span id="statistik_sukses_total" class="info-box-number">Loading...</span>

                    <div class="progress">
                        <div class="progress-bar" style="width: 100%"></div>
                    </div>
                    <span id="statistik_sukses_jumlah" class="progress-description">
                        Loading...
                    </span>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box bg-gradient-warning">
                <span class="info-box-icon"><i class="far fa-clock"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Transaksi Pending</span>
                    <span id="statistik_pending_total" class="info-box-number">Loading...</span>

                    <div class="progress">
                        <div class="progress-bar" style="width: 100%"></div>
                    </div>
                    <span id="statistik_pending_jumlah" class="progress-description">
                        Loading...
                    </span>
                </div>
            </div>
        </div>

        <!-- fix for small devices only -->
        <div class="clearfix hidden-md-up"></div>

        <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box bg-gradient-danger">
                <span class="info-box-icon"><i class="fas fa-poop"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Transaksi Gagal</span>
                    <span id="statistik_gagal_total" class="info-box-number">Loading...</span>

                    <div class="progress">
                        <div class="progress-bar" style="width: 100%"></div>
                    </div>
                    <span id="statistik_gagal_jumlah" class="progress-description">
                        Loading...
                    </span>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box bg-gradient-primary">
                <span class="info-box-icon"><i class="	fas fa-money-bill"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Semua Transaksi</span>
                    <span id="statistik_semua_total" class="info-box-number">Loading...</span>

                    <div class="progress">
                        <div class="progress-bar" style="width: 100%"></div>
                    </div>
                    <span id="statistik_semua_jumlah" class="progress-description">
                        Loading...
                    </span>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">TRANSAKSI PAKET SMS</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id='table' class='table table-bordered table-striped' width='100%'>
                            <thead>
                                <tr>
                                    <th width='100px'>No</th>
                                    <th width='100px'>AKSI</th>
                                    <th width='100px'>STATUS</th>
                                    <th width='100px'>KODE USER</th>
                                    <th width='100px'>NAMA USER</th>
                                    <th width='190px'>KODE TRANSAKSI</th>
                                    <th width='150px'>OPERATOR</th>
                                    <th width='100px'>NOMOR</th>
                                    <th width='250px'>NAMA</th>
                                    <th width='100px'>ADMIN</th>
                                    <th width='100px'>HARGA</th>
                                    <th width='100px'>TOTAL</th>
                                    <th width='100px'>POIN</th>
                                    <th width='190px'>SN</th>
                                    <th width='100px'>KETERANGAN</th>
                                    <th width='100px'>NOTASI</th>
                                    <th width='100px'>TANGGAL</th>
                                    <th width='100px'>RC</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal-notifikasi">
    <div class="modal-dialog modal-notifikasi">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">KIRIM NOTIFIKASI</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-row" hidden>
                    <label for="input1" class="col-lg-2 control-label">HIDDEN DATA</label>
                    <div class="col-lg-10">
                        <input type="text" class="form-control" id="notifikasi_user_kode" name="remoteUrl" placeholder="Tulis judul">
                        <input type="text" class="form-control" id="notifikasi_user_nama" name="remoteUrl" placeholder="Tulis judul">
                        <input type="text" class="form-control" id="notifikasi_kode" name="remoteUrl" placeholder="Tulis judul">
                        <input type="text" class="form-control" id="notifikasi_nomor" name="remoteUrl" placeholder="Tulis judul">
                        <input type="text" class="form-control" id="notifikasi_nama" name="remoteUrl" placeholder="Tulis judul">
                        <input type="text" class="form-control" id="notifikasi_tanggal" name="remoteUrl" placeholder="Tulis judul">
                    </div>
                </div>
                <br>
                <div class="form-row">
                    <label for="input1" class="col-lg-2 control-label">Template</label>
                    <div class="col-lg-10">
                        <select required class="form-control select2bs4 col-sm-2" style="width: 100%;" id="notifikasi_template" name='notifikasi_template' required>Pilih Status
                            <option></option>
                            <option value="1">Ucapan Kenapa Transaksi Gagal?</option>
                            <option value="2">Ucapan Mohon Maaf Karena Transaksi Masih Pending</option>
                            <option value="3">Ucapan Tranasksi Sukses, tapi belum masuk</option>
                            <option value="4">Ucapan Transaksi Diubah Ke Pending</option>
                            <option value="5">Ucapan Terimakasih Sudah Menggunakan Arifah Pulsa</option>
                        </select>
                    </div>
                </div>
                <br>
                <div class="form-row">
                    <label for="input1" class="col-lg-2 control-label">Judul</label>
                    <div class="col-lg-10">
                        <input type="text" class="form-control" id="notifikasi_judul" name="remoteUrl" placeholder="Tulis judul">
                    </div>
                </div>
                <br>
                <div class="form-row">
                    <label for="input1" class="col-lg-2 control-label">Isi</label>
                    <div class="col-lg-10">
                        <textarea class="form-control" id="notifikasi_isi"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-default" data-dismiss="modal">TUTUP</button>
                <button type="button" onclick="aksi_notifikasi_kirim()" class="btn btn-primary">KIRIM</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>




<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>
<script src="<?php echo base_url(); ?>assets/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
    $(function() {
        CKEDITOR.replace('notifikasi_isi', {
            toolbar: [
                ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo'],
                {
                    name: 'basicstyles',
                    items: ['Bold', 'Italic', 'Underline']
                },
                {
                    name: 'links',
                    items: ['Link', 'Unlink', 'Anchor']
                },
            ],
            height: '200px'
        });
    });
</script>

<script type='text/javascript'>
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
    var yyyy = today.getFullYear();
    today = yyyy + '/' + mm + '/' + dd;

    var startDate = today;
    var endDate = today;

    $(document).ready(function() {

        var txt_cari = $("#txt_cari").val();

        //PANGGIL DATA
        aksi_transaksi(startDate, endDate);
        aksi_statistik(startDate, endDate);

        //ENTER
        var input = document.getElementById("txt_cari");
        input.addEventListener("keypress", function(event) {
            if (event.key === "Enter") {
                event.preventDefault();
                document.getElementById("btn_cari").click();
            }
        });

        //CARI
        $('#btn_cari').click(function() {
            var txt_cari = $("#txt_cari").val();
            if (txt_cari.length >= 2) {
                //CLEAR DATA
                var table = $('#table').DataTable();
                table.clear().draw();

                aksi_transaksi(startDate, endDate);
                aksi_statistik(startDate, endDate);
            } else {
                toastr.info('Mohon lengkapi kata kunci pencarian anda!')
            }

        });

        //TANGGAL
        $('#transaksi_tanggal').daterangepicker({
                startDate: moment(),
                endDate: moment(),
                minDate: '01/01/2020',
                maxDate: '12/31/2050',
                dateLimit: {
                    days: 160
                },
                showDropdowns: true,
                showWeekNumbers: true,
                timePicker: false,
                timePickerIncrement: 1,
                timePicker12Hour: true,
                ranges: {
                    'Hari Ini': [moment(), moment()],
                    'Kemarin': [moment().subtract('days', 1), moment().subtract('days', 1)],
                    '7 Hari Terkahir': [moment().subtract('days', 6), moment()],
                    '30 Hari Terakhir': [moment().subtract('days', 29), moment()],
                    'Bulan Ini': [moment().startOf('month'), moment().endOf('month')],
                    'Bulan Lalu': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')],
                    'Tahun Ini': [moment().startOf('year'), moment().endOf('year')],
                    'Tahun Lalu': [moment().subtract('year', 1).startOf('year'), moment().subtract('year', 1).endOf('year')]
                },
                opens: 'left',
                buttonClasses: ['btn btn-default'],
                applyClass: 'btn-small btn-primary',
                cancelClass: 'btn-small',
                format: 'DD/MM/YYYY',
                separator: ' to ',
                locale: {
                    applyLabel: 'Oke',
                    fromLabel: 'Dari',
                    toLabel: 'Ke',
                    customRangeLabel: 'Custom Tanggal',
                    daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
                    monthNames: ['Januari', 'Februari', 'Maret', 'April', 'Mai', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'],
                    firstDay: 1
                }
            },
            function(start, end) {
                console.log("Callback has been called!");
                $('#transaksi_tanggal span').html(start.format('YYYY/MM/DD') + ' - ' + end.format('YYYY/MM/DD'));
                startDate = start.format('YYYY/MM/DD');
                endDate = end.format('YYYY/MM/DD');

                //CLEAR DATA
                var table = $('#table').DataTable();
                table.clear().draw();

                //CLEAR CARI
                $('#txt_cari').val('');

                aksi_transaksi(start.format('YYYY/MM/DD'), end.format('YYYY/MM/DD'));
                aksi_statistik(start.format('YYYY/MM/DD'), end.format('YYYY/MM/DD'));
            }
        );
        //Set the initial state of the picker label
        $('#transaksi_tanggal span').html(moment().subtract('days', 29).format('YYYY/MM/DD') + ' - ' + moment().format('YYYY/MM/DD'));

        $('#transaksi_tanggal').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
        });

        //SELECT2
        $('.select2').select2()
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })


        //MOODAL
        $('#notifikasi_template').on('select2:select', function(e) {
            var notifikasi_template = e.params.data.id;

            var notifikasi_user_kode = $("#notifikasi_user_kode").val();
            var notifikasi_user_nama = $("#notifikasi_user_nama").val();
            var notifikasi_kode = $("#notifikasi_kode").val();
            var notifikasi_nomor = $("#notifikasi_nomor").val();
            var notifikasi_nama = $("#notifikasi_nama").val();
            var notifikasi_tanggal = $("#notifikasi_tanggal").val();

            console.log(notifikasi_template);
            if (notifikasi_template == '1') {
                $('#notifikasi_judul').val('Transaksi Gagal');
                CKEDITOR.instances['notifikasi_isi'].setData(
                    'Hai ' + notifikasi_user_nama + '. ' +
                    'kami mohon maaf atas transaksi kamu yang gagal dengan rincian sebagai berikut :<br>' +
                    'Kode : ' + notifikasi_kode + '<br>' +
                    'Nomor : ' + notifikasi_nomor + '<br>' +
                    'Nama : ' + notifikasi_nama + '<br>' +
                    'Tanggal : ' + notifikasi_tanggal + '<br/><br/> ' +
                    'Setelah kami konfirmasi, transaksi tersebut gagal karena produk dari biller mengalami kendala/kurang stabil.<br/>' +
                    '<br/> Jika ada pertanyaan atau kendala, kamu dapat menghubungi kami melalui whatsapp, telegram dan email. <br/>' +
                    '<br/>' +
                    'Terimakasih telah menggunakan Arifah Pulsa'
                );
            } else if (notifikasi_template == '2') {
                $('#notifikasi_judul').val('Transaksi Pending');
                CKEDITOR.instances['notifikasi_isi'].setData(
                    'Hai ' + notifikasi_user_nama + '. ' +
                    'kami mohon maaf atas transaksi kamu yang masih pending dengan rincian sebagai berikut :<br>' +
                    'Kode : ' + notifikasi_kode + '<br>' +
                    'Nomor : ' + notifikasi_nomor + '<br>' +
                    'Nama : ' + notifikasi_nama + '<br>' +
                    'Tanggal : ' + notifikasi_tanggal + '<br/><br/> ' +
                    'Setelah kami konfirmasi, transaksi tersebut pending karena produk dari biller mengalami kendala/kurang stabil.<br/><br/> ' +
                    'Saat ini kami sedang melakukan follow-up transaksi tersebut ke biller, mohon ditunggu dan terimakasih atas kesabarannya.' +
                    'Kami akan mengirimkan notifikasi kembali jika sudah ada info terbaru terkait transaksi tersebut.<br/><br/> ' +
                    'Jika ada pertanyaan atau kendala, kamu dapat menghubungi kami melalui whatsapp, telegram dan email.<br/><br/> ' +
                    'Terimakasih telah menggunakan Arifah Pulsa<br/><br/> '
                );
            } else if (notifikasi_template == '3') {
                $('#notifikasi_judul').val('Transaksi dalam penanganan');
                CKEDITOR.instances['notifikasi_isi'].setData(
                    'Hai ' + notifikasi_user_nama + '. ' +
                    'kami mohon maaf atas transaksi kamu yang sukses tapi belum valid dengan rincian sebagai berikut :<br>' +
                    'Kode : ' + notifikasi_kode + '<br>' +
                    'Nomor : ' + notifikasi_nomor + '<br>' +
                    'Nama : ' + notifikasi_nama + '<br>' +
                    'Tanggal : ' + notifikasi_tanggal + '<br/><br/> ' +
                    'Setelah kami konfirmasi, transaksi tersebut sukses tetapi belum valid karena produk dari biller mengalami kendala/kurang stabil.<br/><br/>' +
                    'Transaksi tersebut dalam penanganan oleh tim Arifah Pulsa, mohon ditunggu dan terimakasih atas kesabarannya.' +
                    'Kami akan mengirimkan notifikasi kembali jika sudah ada info terbaru terkait transaksi tersebut.<br/><br/> ' +
                    'Jika ada pertanyaan atau kendala, kamu dapat menghubungi kami melalui whatsapp, telegram dan email.<br/><br/> ' +
                    'Terimakasih telah menggunakan Arifah Pulsa<br/><br/> '
                );
            } else if (notifikasi_template == '4') {
                $('#notifikasi_judul').val('Perubahan status transaksi ke pending');
                CKEDITOR.instances['notifikasi_isi'].setData(
                    'Hai ' + notifikasi_user_nama + '. ' +
                    'kami mohon maaf atas transaksi kamu karena ada perubahan status transaksi menjadi pending dengan rincian sebagai berikut :<br>' +
                    'Kode : ' + notifikasi_kode + '<br>' +
                    'Nomor : ' + notifikasi_nomor + '<br>' +
                    'Nama : ' + notifikasi_nama + '<br>' +
                    'Tanggal : ' + notifikasi_tanggal + '<br/><br/> ' +
                    'Setelah kami konfirmasi, transaksi tersebut pending karena produk dari biller mengalami kendala/kurang stabil.<br/><br/>' +
                    'Transaksi tersebut dalam penanganan oleh tim Arifah Pulsa, mohon ditunggu dan terimakasih atas kesabarannya.' +
                    'Kami akan mengirimkan notifikasi kembali jika sudah ada info terbaru terkait transaksi tersebut.<br/><br/> ' +
                    'Jika ada pertanyaan atau kendala, kamu dapat menghubungi kami melalui whatsapp, telegram dan email.<br/><br/> ' +
                    'Terimakasih telah menggunakan Arifah Pulsa<br/><br/> '
                );
            } else if (notifikasi_template == '5') {
                $('#notifikasi_judul').val('Terimakasih telah menggunakan Arifah Pulsa');
                CKEDITOR.instances['notifikasi_isi'].setData(
                    'Hai ' + notifikasi_user_nama + '. ' +
                    'Tranasksi kamu telah sukses dengan rincian sebagai berikut :<br>' +
                    'Kode : ' + notifikasi_kode + '<br>' +
                    'Nomor : ' + notifikasi_nomor + '<br>' +
                    'Nama : ' + notifikasi_nama + '<br>' +
                    'Tanggal : ' + notifikasi_tanggal + '<br/><br/> ' +
                    'Kami sangat berterimakasih atas kepercayaan kamu karena telah menggunakan Arifah Pulsa.' +
                    'Kami akan selalu memberikan pelayanan terbaik dan menjadi partner digital terbaik kamu dalam tranasaksi produk digital<br/><br/>' +
                    'Jika ada pertanyaan atau kendala, kamu dapat menghubungi kami melalui whatsapp, telegram dan email.<br/><br/> ' +
                    'Terimakasih telah menggunakan Arifah Pulsa<br/><br/> '
                );
            }

        });

    });


    function aksi_transaksi(startDate, endDate) {
        var txt_cari = $("#txt_cari").val();
        $('#table').DataTable({
            "destroy": true,
            "searching": true,
            "processing": true,
            "serverSide": true,
            'scrollX': true,
            'sScrollX': '100%',
            'sScrollY': '500',
            'ordering': false,
            "info": true,
            "paging": true,
            "order": [],
            "ajax": {
                "url": "<?php echo site_url('/transaksi/transaksi_paket_sms/aksi_transaksi') ?>",
                "type": "POST",
                data: {
                    startDate: startDate,
                    endDate: endDate,
                    txt_cari: txt_cari,
                }
            },
            "dom": "<'row'<'col-sm-12 col-md-12'l><'col-sm-12 col-md-6'B><'col-sm-12 col-md-6'f>>" +
                "<'row'<'.col-md-6:eq(0)'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            "buttons": ["copy", "print"],

        });
    }

    function aksi_statistik(startDate, endDate) {
        var txt_cari = $("#txt_cari").val();
        document.getElementById("statistik_sukses_total").innerHTML = 'Loading...';
        document.getElementById("statistik_sukses_jumlah").innerHTML = 'Loading...';
        document.getElementById("statistik_pending_total").innerHTML = 'Loading...';
        document.getElementById("statistik_pending_jumlah").innerHTML = 'Loading...';
        document.getElementById("statistik_gagal_total").innerHTML = 'Loading...';
        document.getElementById("statistik_gagal_jumlah").innerHTML = 'Loading...';
        document.getElementById("statistik_semua_total").innerHTML = 'Loading...';
        document.getElementById("statistik_semua_jumlah").innerHTML = 'Loading...';

        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>transaksi/transaksi_paket_sms/aksi_statistik',
            data: {
                startDate: startDate,
                endDate: endDate,
                txt_cari: txt_cari,
            },
            success: function(data) {
                var obj = JSON.parse(data);
                var statistik_sukses_total = obj.statistik_sukses_total;
                var statistik_sukses_jumlah = obj.statistik_sukses_jumlah;
                var statistik_pending_total = obj.statistik_pending_total;
                var statistik_pending_jumlah = obj.statistik_pending_jumlah;
                var statistik_gagal_total = obj.statistik_gagal_total;
                var statistik_gagal_jumlah = obj.statistik_gagal_jumlah;
                var statistik_semua_total = obj.statistik_semua_total;
                var statistik_semua_jumlah = obj.statistik_semua_jumlah;


                document.getElementById("statistik_sukses_total").innerHTML = obj.statistik_sukses_total;
                document.getElementById("statistik_sukses_jumlah").innerHTML = obj.statistik_sukses_jumlah + ' transaksi';
                document.getElementById("statistik_pending_total").innerHTML = obj.statistik_pending_total;
                document.getElementById("statistik_pending_jumlah").innerHTML = obj.statistik_pending_jumlah + ' transaksi';
                document.getElementById("statistik_gagal_total").innerHTML = obj.statistik_gagal_total;
                document.getElementById("statistik_gagal_jumlah").innerHTML = obj.statistik_gagal_jumlah + ' transaksi';
                document.getElementById("statistik_semua_total").innerHTML = obj.statistik_semua_total;
                document.getElementById("statistik_semua_jumlah").innerHTML = obj.statistik_semua_jumlah + ' transaksi';
            }
        })
    }

    function aksi_notifikasi_modal(element) {
        $("#modal-notifikasi").modal("show");

        var table = $('#table').DataTable();
        var data_row = table.row($(element).closest('tr')).data();

        var notifikasi_user_kode = data_row[3];
        var notifikasi_user_nama = data_row[4];
        var notifikasi_kode = data_row[5];
        var notifikasi_nomor = data_row[7];
        var notifikasi_nama = data_row[8];
        var notifikasi_tanggal = data_row[16];

        document.getElementById("notifikasi_user_kode").value = notifikasi_user_kode;
        document.getElementById("notifikasi_user_nama").value = notifikasi_user_nama;
        document.getElementById("notifikasi_kode").value = notifikasi_kode;
        document.getElementById("notifikasi_nomor").value = notifikasi_nomor;
        document.getElementById("notifikasi_nama").value = notifikasi_nama;
        document.getElementById("notifikasi_tanggal").value = notifikasi_tanggal;
    }

    function aksi_notifikasi_kirim() {
        var notifikasi_user_kode = $("#notifikasi_user_kode").val();
        var notifikasi_judul = $("#notifikasi_judul").val();
        var notifikasi_isi = CKEDITOR.instances['notifikasi_isi'].getData();

        if (notifikasi_judul.length > 5 && notifikasi_isi.length > 10) {
            Swal.fire({
                title: 'Apakah sudah benar?',
                text: "Pastikan notifikasi menggunakan bahasa yang sopan dan sesuai SOP. Jika menekan tombol kirim dibawah, maka pesan akan masuk ke inbox user.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Kirim!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '<?php echo base_url() ?>transaksi/transaksi_paket_sms/aksi_notifikasi',
                        type: "POST",
                        data: {
                            notifikasi_user_kode: notifikasi_user_kode,
                            notifikasi_judul: notifikasi_judul,
                            notifikasi_isi: notifikasi_isi
                        },
                        success: function(data) {
                            var obj = JSON.parse(data);
                            var notifikasi_status = obj.notifikasi_status;
                            if (notifikasi_status == '0') {
                                toastr.success('Notifikasi berhasil terikirm');
                                $("#modal-notifikasi").modal('hide');

                                //CLEAR DATA
                                $('#notifikasi_judul').val('Transaksi gagal');
                                CKEDITOR.instances['notifikasi_isi'].setData('');
                            } else {
                                toastr.error('Notifikasi gagal terkirim');
                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError, data) {
                            var obj = JSON.parse(data);
                            toastr.error('Notifikasi gagal terkirim');
                        }
                    });

                }
            })
        } else {
            toastr.info('Mohon isi data dengan benar')
        }



    }

    function aksi_sukses() {
        $(document).Toasts('create', {
            class: 'bg-success',
            title: 'Cara mengubah status ke SUKSES',
            subtitle: '',
            body: 'Untuk mengubah status transaksi ke SUKSES dan GAGAL dilakukan melalui dashboard Digiflazz Arifah Pulsa. Pastikan sebelum mengubah ke status SUKSES atau GAGAL, lakukan SET KE PENDING terlebih dahulu.'
        })
    }

    function aksi_gagal() {
        $(document).Toasts('create', {
            class: 'bg-danger',
            title: 'Cara mengubah status ke GAGAL',
            subtitle: '',
            body: 'Untuk mengubah status transaksi ke SUKSES dan GAGAL dilakukan melalui dashboard Digiflazz Arifah Pulsa. Pastikan sebelum mengubah ke status SUKSES atau GAGAL, lakukan SET KE PENDING terlebih dahulu.'
        })
    }

    function aksi_pending($trx_paket_sms_kode) {
        Swal.fire({
            title: 'Ganti status transaksi?',
            text: "Status transaksi akan diubah ke pending. Ubah ke status pending apabila terjadi kendala pada suatu transaksi.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Ya, ubah ke pending!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>transaksi/transaksi_paket_sms/aksi_pending/' + $trx_paket_sms_kode,
                    type: "POST",
                    dataType: "html",
                    success: function(data) {
                        var obj = JSON.parse(data);
                        var transaksi_status = obj.transaksi_status;

                        if (transaksi_status == '0') {
                            toastr.success('Berhasil mengubah status transaksi');

                            //CLEAR DATA
                            var table = $('#table').DataTable();
                            table.clear().draw();


                            //CLEAR CARI
                            $('#txt_cari').val('');

                            aksi_transaksi(startDate, endDate);
                            aksi_statistik(startDate, endDate);
                        } else {
                            toastr.error('Gagal mengubah status transaksi, karena status saat ini sedang pending');

                            //CLEAR DATA
                            var table = $('#table').DataTable();
                            table.clear().draw();


                            //CLEAR CARI
                            $('#txt_cari').val('');

                            aksi_transaksi(startDate, endDate);
                            aksi_statistik(startDate, endDate);
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError, data) {
                        var obj = JSON.parse(data);


                        //CLEAR DATA
                        var table = $('#table').DataTable();
                        table.clear().draw();

                        //CLEAR CARI
                        $('#txt_cari').val('');

                        aksi_transaksi(startDate, endDate);
                        aksi_statistik(startDate, endDate);

                        toastr.error('Gagal mengubah status transaksi');
                    }
                });

            }
        })
    }
</script>