<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div id="tabel_loading" class="overlay d-flex justify-content-center align-items-center">
                    <i class="fas fa-2x fa-sync fa-spin"></i>
                </div>
                <div class="card-header">
                    <h3 class="card-title">BANNER</h3>
                </div>
                <div class="card-body">
                    <a class="btn btn-primary" onclick="aksi_tambah_modal()">Tambah</a> &nbsp;
                    <div style="margin-bottom: 10px;"></div>
                    <div id="tabel" class="table-responsive">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal_banner">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div id="modal_loading" class="overlay d-flex justify-content-center align-items-center">
                <i class="fas fa-2x fa-sync fa-spin"></i>
            </div>
            <form enctype="multipart/form-data" id="submit">
                <div class="modal-header">
                    <h4 id="modal_title" class="modal-title">TAMBAH DATA</h4>
                    <button type="button" class="close" onclick="aksi_tutup_modal()" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Kode</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_banner_kode" name="mst_banner_kode" placeholder="Kode banner">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Kategori</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_banner_kategori" name="mst_banner_kategori" placeholder="Kode banner">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Tipe</label>
                                <div class="col-lg-10">
                                    <select required class="form-control select2bs4" onchange="aksi_tipe()" style="width: 100%;" id="mst_banner_tipe" name='mst_banner_tipe' required>
                                        <option selected="selected"></option>
                                        <option value="Video">Video</option>
                                        <option value="Gambar">Gambar</option>
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Video</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_banner_video" name="mst_banner_video" placeholder="ID Video youtube">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Gambar</label>
                                <div class="col-lg-10">
                                    <input type="file" class="form-control" id="mst_banner_gambar" name="mst_banner_gambar">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Judul</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_banner_judul" name="mst_banner_judul" placeholder="Judul banner">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Isi</label>
                                <div class="col-lg-10">
                                    <textarea class="form-control" id="mst_banner_isi" name="mst_banner_isi"></textarea>
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Link</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_banner_link" name="mst_banner_link" placeholder="Link selengkapnya">
                                </div>
                            </div>

                        </div>
                    </div>

                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" onclick="aksi_tutup_modal()">TUTUP</button>
                    <button type="submit" id="btn_simpan" class="btn btn-primary">SIMPAN</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>
<script src="<?php echo base_url(); ?>assets/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
    $(function() {
        CKEDITOR.replace('mst_banner_isi', {
            toolbar: [
                ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo'],
                {
                    name: 'basicstyles',
                    items: ['Bold', 'Italic', 'Underline']
                },
                {
                    name: 'links',
                    items: ['Link', 'Unlink', 'Anchor']
                },
            ],
            height: '200px'
        });
    });
</script>

<script type='text/javascript'>
    var submit_status;
    $(document).ready(function() {
        aksi_data();

        document.getElementById("mst_banner_video").disabled = true;
        aksi_tipe();
    });

    $('#submit').submit(function(e) {
        e.preventDefault();
        var mst_banner_kode = $("#mst_banner_kode").val();
        var mst_banner_kategori = $("#mst_banner_kategori").val();
        var mst_banner_tipe = $("#mst_banner_tipe").val();
        var mst_banner_video = $("#mst_banner_video").val();
        var mst_banner_gambar = $("#mst_banner_gambar").val();
        var mst_banner_judul = $("#mst_banner_judul").val();
        var mst_banner_isi = CKEDITOR.instances['mst_banner_isi'].getData();
        var mst_banner_link = $("#mst_banner_link").val();

        //EDIT
        if (submit_status == 'Edit') {
            if (mst_banner_kode.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_banner_judul.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                var formData = new FormData();
                formData.append("mst_banner_kode", mst_banner_kode);
                formData.append("mst_banner_kategori", mst_banner_kategori);
                formData.append("mst_banner_tipe", mst_banner_tipe);
                formData.append("mst_banner_video", mst_banner_video);
                formData.append("mst_banner_gambar", $("#mst_banner_gambar")[0].files[0]);
                formData.append("mst_banner_judul", mst_banner_judul);
                formData.append("mst_banner_isi", mst_banner_isi);
                formData.append("mst_banner_link", mst_banner_link);

                $.ajax({
                    url: '<?php echo base_url() ?>banner/aksi_edit',
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        toastr.success('Banner berhasil di edit');

                        //SET VALUE
                        document.getElementById("mst_banner_kode").value = '';
                        document.getElementById("mst_banner_kategori").value = '';
                        $("#mst_banner_tipe").val('').trigger("change");
                        document.getElementById("mst_banner_video").value = '';
                        document.getElementById("mst_banner_gambar").value = '';
                        document.getElementById("mst_banner_judul").value = '';
                        CKEDITOR.instances['mst_banner_isi'].setData('');
                        document.getElementById("mst_banner_link").value = '';

                        //LOADING
                        document.getElementById("modal_loading").style.visibility = "hidden";

                        //MODAL
                        $("#modal_banner").modal('hide');

                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Banner gagal di edit');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

        //TAMBAH
        if (submit_status == 'Tambah') {
            if (mst_banner_kode.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_banner_gambar.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_banner_judul.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                var formData = new FormData();
                formData.append("mst_banner_kode", mst_banner_kode);
                formData.append("mst_banner_kategori", mst_banner_kategori);
                formData.append("mst_banner_tipe", mst_banner_tipe);
                formData.append("mst_banner_video", mst_banner_video);
                formData.append("mst_banner_gambar", $("#mst_banner_gambar")[0].files[0]);
                formData.append("mst_banner_judul", mst_banner_judul);
                formData.append("mst_banner_isi", mst_banner_isi);
                formData.append("mst_banner_link", mst_banner_link);

                $.ajax({
                    url: '<?php echo base_url() ?>banner/aksi_tambah',
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        var obj = JSON.parse(data);
                        var tambah_status = obj.tambah_status;

                        if (tambah_status == '0') {
                            toastr.success('Banner berhasil di tambahkan');

                            //SET VALUE
                            document.getElementById("mst_banner_kode").value = '';
                            document.getElementById("mst_banner_kategori").value = '';
                            $("#mst_banner_tipe").val('').trigger("change");
                            document.getElementById("mst_banner_video").value = '';
                            document.getElementById("mst_banner_gambar").value = '';
                            document.getElementById("mst_banner_judul").value = '';
                            CKEDITOR.instances['mst_banner_isi'].setData('');
                            document.getElementById("mst_banner_link").value = '';

                            //LOADING
                            document.getElementById("modal_loading").style.visibility = "hidden";

                            aksi_data();
                        } else {
                            toastr.error('Banner gagal di tambahkan karena kode banner sudah pernah ditambahkan sebelumnya!');
                            document.getElementById("modal_loading").style.visibility = "hidden";
                        }

                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Banner gagal di tambahkan');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

    });

    function aksi_data() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>banner/aksi_data',
            success: function(html) {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                $("#tabel").html(html);
            }
        })
    }

    function aksi_edit_modal(element) {
        document.getElementById("modal_loading").style.visibility = "hidden";

        var $row = $(element).closest("tr");
        var mst_banner_kode = $row.find("#tbl_mst_banner_kode").text();
        var mst_banner_kategori = $row.find("#tbl_mst_banner_kategori").text();
        var mst_banner_tipe = $row.find("#tbl_mst_banner_tipe").text();
        var mst_banner_video = $row.find("#tbl_mst_banner_video").text();
        var mst_banner_judul = $row.find("#tbl_mst_banner_judul").text();
        var mst_banner_isi = $row.find("#tbl_mst_banner_isi").text();
        var mst_banner_link = $row.find("#tbl_mst_banner_link").text();

        //SET VALUE
        document.getElementById("mst_banner_kode").value = mst_banner_kode;
        document.getElementById("mst_banner_kategori").value = mst_banner_kategori;
        $("#mst_banner_tipe").val(mst_banner_tipe).trigger("change");
        document.getElementById("mst_banner_video").value = mst_banner_video;
        document.getElementById("mst_banner_judul").value = mst_banner_judul;
        CKEDITOR.instances['mst_banner_isi'].setData(mst_banner_isi);
        document.getElementById("mst_banner_link").value = mst_banner_link;

        //DISABLE VALUE
        document.getElementById("mst_banner_kode").readOnly = true;

        //SET STATUS
        submit_status = 'Edit';

        //SET TITLE
        $("#modal_title").html('EDIT BANNER');

        //SHOW MODAL
        $('#modal_banner').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_tambah_modal() {
        document.getElementById("modal_loading").style.visibility = "hidden";

        //SET TITLE
        $("#modal_title").html('TAMBAH BANNER');

        //ENABLE VALUE
        document.getElementById("mst_banner_kode").readOnly = false;

        //SET VALUE
        document.getElementById("mst_banner_kode").value = '';
        document.getElementById("mst_banner_kategori").value = '';
        $("#mst_banner_tipe").val('').trigger("change");
        document.getElementById("mst_banner_video").value = '';
        document.getElementById("mst_banner_gambar").value = '';
        document.getElementById("mst_banner_judul").value = '';
        CKEDITOR.instances['mst_banner_isi'].setData('');
        document.getElementById("mst_banner_link").value = '';

        //SET STATUS
        submit_status = 'Tambah';

        //SHOW MODAL
        $('#modal_banner').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }

    function aksi_tidak_aktif(mst_banner_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>banner/aksi_tidak_aktif/' + mst_banner_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status banner menjadi tidak aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status banner menjadi tidak aktif');
            }
        });
    }

    function aksi_aktif(mst_banner_kode) {
        $.ajax({
            url: '<?php echo base_url() ?>banner/aksi_aktif/' + mst_banner_kode,
            type: "POST",
            success: function() {
                toastr.success('Berhasil mengubah status banner menjadi aktif');
                aksi_data();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                toastr.error('Gagal mengubah status banner menjadi tidak aktif');
            }
        });
    }

    function aksi_hapus(mst_banner_kode) {
        Swal.fire({
            title: 'Yakin ingin menghapus banner?',
            text: "Setelah menghapus, data tidak bisa dikembalikan lagi!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Hapus!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>banner/aksi_hapus/' + mst_banner_kode,
                    type: "POST",
                    success: function() {
                        toastr.success('Berhasil menghapus banner');
                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Gagal menghapus banner');
                    }
                });
            }
        })


    }

    function aksi_tutup_modal() {
        aksi_data();
        document.getElementById("modal_loading").style.visibility = "hidden";
        $("#modal_banner").modal('hide');
    }

    function aksi_tipe() {
        var mst_banner_tipe = $("#mst_banner_tipe").val();

        if (mst_banner_tipe == "Video") {
            document.getElementById("mst_banner_video").disabled = false;
        }

        if (mst_banner_tipe == "Gambar") {
            document.getElementById("mst_banner_video").disabled = true;
        }
    }
</script>