<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div id="tabel_loading" class="overlay d-flex justify-content-center align-items-center">
                    <i class="fas fa-2x fa-sync fa-spin"></i>
                </div>
                <div class="card-header">
                    <h3 class="card-title">BONUS</h3>
                </div>
                <div class="card-body">
                    <div style="margin-bottom: 10px;"></div>
                    <div id="tabel" class="table-responsive">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal_bonus">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div id="modal_loading" class="overlay d-flex justify-content-center align-items-center">
                <i class="fas fa-2x fa-sync fa-spin"></i>
            </div>
            <form enctype="multipart/form-data" id="submit">
                <div class="modal-header">
                    <h4 id="modal_title" class="modal-title">TAMBAH DATA</h4>
                    <button type="button" class="close" onclick="aksi_tutup_modal()" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Kode</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_bonus_kode" name="mst_bonus_kode" placeholder="Kode bonus">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Nama</label>
                                <div class="col-lg-10">
                                    <select required class="form-control select2bs4" style="width: 100%;" id="mst_bonus_nama" name='mst_bonus_nama' required>
                                        <option selected="selected"></option>
                                        <option value="Silver">Silver</option>
                                        <option value="Gold">Gold</option>
                                        <option value="Diamond">Diamond</option>
                                    </select>
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Poin</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_bonus_poin" placeholder="Jumlah bonus poin">
                                </div>
                            </div>


                        </div>

                        <div class="col-md-6">
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Admin</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_bonus_admin" placeholder="Biaya admin">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Harga</label>
                                <div class="col-lg-10">
                                    <input type="number" class="form-control" id="mst_bonus_harga" placeholder="Harga">
                                </div>
                            </div>
                            <br>
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Notasi</label>
                                <div class="col-lg-10">
                                    <input type="text" class="form-control" id="mst_bonus_notasi" name="mst_bonus_notasi">
                                </div>
                            </div>
                        </div>

                        <div style="margin-top: 20px;" class="col-md-12">
                            <div class="form-row">
                                <label for="input1" class="col-lg-2 control-label">Keterangan</label>
                                <div class="col-lg-12">
                                    <textarea class="form-control" id="mst_bonus_keterangan" name="mst_bonus_keterangan"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" onclick="aksi_tutup_modal()">TUTUP</button>
                    <button type="submit" id="btn_simpan" class="btn btn-primary">SIMPAN</button>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>


<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>
<script src="<?php echo base_url(); ?>assets/ckeditor/ckeditor.js"></script>

<script type='text/javascript'>
    var submit_status;
    $(document).ready(function() {
        aksi_data();

        //FORMAT RUPIAH
        var mst_bonus_admin = document.getElementById('mst_bonus_admin');
        mst_bonus_admin.addEventListener('keyup', function(e) {
            mst_bonus_admin.value = aksi_rupiah(this.value, '');
        });

        var mst_bonus_harga = document.getElementById('mst_bonus_harga');
        mst_bonus_harga.addEventListener('keyup', function(e) {
            mst_bonus_harga.value = aksi_rupiah(this.value, '');
        });
    });

    $('#submit').submit(function(e) {
        e.preventDefault();
        var mst_bonus_kode = $("#mst_bonus_kode").val();
        var mst_bonus_nama = $("#mst_bonus_nama").val();
        var mst_bonus_poin = $("#mst_bonus_poin").val();
        var mst_bonus_admin = $("#mst_bonus_admin").val();
        var mst_bonus_harga = $("#mst_bonus_harga").val();
        var mst_bonus_notasi = $("#mst_bonus_notasi").val();
        var mst_bonus_keterangan = $("#mst_bonus_keterangan").val();

        //EDIT
        if (submit_status == 'Edit') {
            if (mst_bonus_kode.length < 3) {
                toastr.error('Data belum lengkap');
            } else if (mst_bonus_nama.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_bonus_poin.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_bonus_admin.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_bonus_harga.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_bonus_notasi.length < 1) {
                toastr.error('Data belum lengkap');
            } else if (mst_bonus_keterangan.length < 1) {
                toastr.error('Data belum lengkap');
            } else {
                document.getElementById("modal_loading").style.visibility = "visible";

                var formData = new FormData();
                formData.append("mst_bonus_kode", mst_bonus_kode);
                formData.append("mst_bonus_nama", mst_bonus_nama);
                formData.append("mst_bonus_poin", mst_bonus_poin);
                formData.append("mst_bonus_admin", mst_bonus_admin);
                formData.append("mst_bonus_harga", mst_bonus_harga);
                formData.append("mst_bonus_notasi", mst_bonus_notasi);
                formData.append("mst_bonus_keterangan", mst_bonus_keterangan);

                $.ajax({
                    url: '<?php echo base_url() ?>referral/aksi_edit',
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    cache: false,
                    async: false,
                    success: function(data) {
                        toastr.success('Hadiah berhasil di edit');

                        //SET VALUE
                        document.getElementById("mst_bonus_kode").value = '';
                        $("#mst_bonus_nama").val('').trigger("change");
                        document.getElementById("mst_bonus_poin").value = '';
                        document.getElementById("mst_bonus_admin").value = '';
                        document.getElementById("mst_bonus_harga").value = '';
                        document.getElementById("mst_bonus_notasi").value = '';
                        document.getElementById("mst_bonus_keterangan").value = '';

                        //LOADING
                        document.getElementById("modal_loading").style.visibility = "hidden";

                        //MODAL
                        $("#modal_bonus").modal('hide');

                        aksi_data();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        toastr.error('Hadiah gagal di edit');
                        document.getElementById("modal_loading").style.visibility = "hidden";
                    }
                });
            }
        }

    });

    function aksi_data() {
        document.getElementById("tabel_loading").style.visibility = "visible";
        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>referral/aksi_data',
            success: function(html) {
                document.getElementById("tabel_loading").style.visibility = "hidden";
                $("#tabel").html(html);
            }
        })
    }

    function aksi_edit_modal(element) {
        document.getElementById("modal_loading").style.visibility = "hidden";

        var $row = $(element).closest("tr");
        var mst_bonus_kode = $row.find("#tbl_mst_bonus_kode").text();
        var mst_bonus_nama = $row.find("#tbl_mst_bonus_nama").text();
        var mst_bonus_poin = $row.find("#tbl_mst_bonus_poin").text();
        var mst_bonus_admin = $row.find("#tbl_mst_bonus_admin").text();
        var mst_bonus_harga = $row.find("#tbl_mst_bonus_harga").text();
        var mst_bonus_notasi = $row.find("#tbl_mst_bonus_notasi").text();
        var mst_bonus_keterangan = $row.find("#tbl_mst_bonus_keterangan").text();


        //SET VALUE
        document.getElementById("mst_bonus_kode").value = mst_bonus_kode;
        $("#mst_bonus_nama").val(mst_bonus_nama).trigger("change");
        document.getElementById("mst_bonus_poin").value = mst_bonus_poin;
        document.getElementById("mst_bonus_admin").value = mst_bonus_admin;
        document.getElementById("mst_bonus_harga").value = mst_bonus_harga;
        document.getElementById("mst_bonus_notasi").value = mst_bonus_notasi;
        document.getElementById("mst_bonus_keterangan").value = mst_bonus_keterangan;

        //DISABLE VALUE
        document.getElementById("mst_bonus_kode").readOnly = true;

        //SET STATUS
        submit_status = 'Edit';

        //SET TITLE
        $("#modal_title").html('EDIT BONUS');

        //SHOW MODAL
        $('#modal_bonus').modal({
            backdrop: 'static',
            keyboard: false
        }, 'show');
    }
</script>