<div class="container-fluid">
    <div class="row">
        <div style="margin-bottom: 10px;" class="col-md-3">
            <input type="text" class="form-control col-md-12" id="user_tanggal" placeholder="Pilih tanggal">
        </div>

        <div style="margin-bottom: 10px;" class="col-md-7">
            <input type="text" class="form-control col-md-12" id="txt_cari" placeholder="Cari kode user, nama user, nomor HP, status atau email">

        </div>

        <div style="margin-bottom: 10px;" class="col-md-2">
            <button type="button" id="btn_cari" class="btn btn-primary col-md-12">Cari</button>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box bg-gradient-success">
                <span class="info-box-icon"><i class="fas fa-chart-line"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">User Aktif</span>
                    <span id="statistik_aktif_jumlah" class="info-box-number">Loading...</span>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box bg-gradient-warning">
                <span class="info-box-icon"><i class="far fa-clock"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">User Freeze</span>
                    <span id="statistik_bekukan_jumlah" class="info-box-number">Loading...</span>

                </div>
            </div>
        </div>

        <!-- fix for small devices only -->
        <div class="clearfix hidden-md-up"></div>

        <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box bg-gradient-danger">
                <span class="info-box-icon"><i class="fas fa-poop"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">User Blokir</span>
                    <span id="statistik_blokir_jumlah" class="info-box-number">Loading...</span>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box bg-gradient-primary">
                <span class="info-box-icon"><i class="	fas fa-users"></i></span>
                <div class="info-box-content">
                    <span class="info-box-text">Semua User</span>
                    <span id="statistik_semua_jumlah" class="info-box-number">Loading...</span>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">USER</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id='table' class='table table-bordered table-striped' width='100%'>
                            <thead>
                                <tr>
                                    <th width='100px'>No</th>
                                    <th width='100px'>AKSI</th>
                                    <th width='100px'>STATUS</th>
                                    <th width='100px'>KODE USER</th>
                                    <th width='100px'>NAMA USER</th>
                                    <th width='190px'>NOMOR HP</th>
                                    <th width='190px'>EMAIL</th>
                                    <th width='100px'>TIPE</th>
                                    <th width='250px'>REFERRAL KODE</th>
                                    <th width='100px'>REFERRAL BONUS</th>
                                    <th width='100px'>UPLINE KODE</th>
                                    <th width='100px'>FIREBASE</th>
                                    <th width='190px'>TOKEN</th>
                                    <th width='100px'>ZONA WAKTU</th>
                                    <th width='100px'>TANGGAL DAFTAR</th>
                                    <th width='100px'>TERAKHIR AKTIF</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal-notifikasi">
    <div class="modal-dialog modal-notifikasi">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">KIRIM NOTIFIKASI</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-row" hidden>
                    <label for="input1" class="col-lg-2 control-label">HIDDEN DATA</label>
                    <div class="col-lg-10">
                        <input type="text" class="form-control" id="notifikasi_user_kode" name="remoteUrl" placeholder="Tulis judul">
                    </div>
                </div>
                <div class="form-row">
                    <label for="input1" class="col-lg-2 control-label">Judul</label>
                    <div class="col-lg-10">
                        <input type="text" class="form-control" id="notifikasi_judul" name="remoteUrl" placeholder="Tulis judul">
                    </div>
                </div>
                <br>
                <div class="form-row">
                    <label for="input1" class="col-lg-2 control-label">Isi</label>
                    <div class="col-lg-10">
                        <textarea class="form-control" id="notifikasi_isi"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer justify-content-between">
                <button type="button" class="btn btn-default" data-dismiss="modal">TUTUP</button>
                <button type="button" onclick="aksi_notifikasi_kirim()" class="btn btn-primary">KIRIM</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>




<script src="<?php echo base_url(); ?>assets/plugins/jquery/jquery.min.js"></script>
<script src="<?php echo base_url(); ?>assets/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
    $(function() {
        CKEDITOR.replace('notifikasi_isi', {
            toolbar: [
                ['Cut', 'Copy', 'Paste', 'PasteText', 'PasteFromWord', '-', 'Undo', 'Redo'],
                {
                    name: 'basicstyles',
                    items: ['Bold', 'Italic', 'Underline']
                },
                {
                    name: 'links',
                    items: ['Link', 'Unlink', 'Anchor']
                },
            ],
            height: '200px'
        });
    });
</script>

<script type='text/javascript'>
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
    var yyyy = today.getFullYear();
    today = yyyy + '/' + mm + '/' + dd;

    var startDate = today;
    var endDate = today;

    $(document).ready(function() {

        var txt_cari = $("#txt_cari").val();

        //PANGGIL DATA
        aksi_user(startDate, endDate);
        aksi_statistik(startDate, endDate);

        //ENTER
        var input = document.getElementById("txt_cari");
        input.addEventListener("keypress", function(event) {
            if (event.key === "Enter") {
                event.preventDefault();
                document.getElementById("btn_cari").click();
            }
        });

        //CARI
        $('#btn_cari').click(function() {
            var txt_cari = $("#txt_cari").val();
            if (txt_cari.length >= 2) {
                //CLEAR DATA
                var table = $('#table').DataTable();
                table.clear().draw();

                aksi_user(startDate, endDate);
                aksi_statistik(startDate, endDate);
            } else {
                toastr.info('Mohon lengkapi kata kunci pencarian anda!')
            }

        });

        //TANGGAL
        $('#user_tanggal').daterangepicker({
                startDate: moment(),
                endDate: moment(),
                minDate: '01/01/2020',
                maxDate: '12/31/2050',
                dateLimit: {
                    days: 160
                },
                showDropdowns: true,
                showWeekNumbers: true,
                timePicker: false,
                timePickerIncrement: 1,
                timePicker12Hour: true,
                ranges: {
                    'Hari Ini': [moment(), moment()],
                    'Kemarin': [moment().subtract('days', 1), moment().subtract('days', 1)],
                    '7 Hari Terkahir': [moment().subtract('days', 6), moment()],
                    '30 Hari Terakhir': [moment().subtract('days', 29), moment()],
                    'Bulan Ini': [moment().startOf('month'), moment().endOf('month')],
                    'Bulan Lalu': [moment().subtract('month', 1).startOf('month'), moment().subtract('month', 1).endOf('month')],
                    'Tahun Ini': [moment().startOf('year'), moment().endOf('year')],
                    'Tahun Lalu': [moment().subtract('year', 1).startOf('year'), moment().subtract('year', 1).endOf('year')]
                },
                opens: 'left',
                buttonClasses: ['btn btn-default'],
                applyClass: 'btn-small btn-primary',
                cancelClass: 'btn-small',
                format: 'DD/MM/YYYY',
                separator: ' to ',
                locale: {
                    applyLabel: 'Oke',
                    fromLabel: 'Dari',
                    toLabel: 'Ke',
                    customRangeLabel: 'Custom Tanggal',
                    daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
                    monthNames: ['Januari', 'Februari', 'Maret', 'April', 'Mai', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'],
                    firstDay: 1
                }
            },
            function(start, end) {
                console.log("Callback has been called!");
                $('#user_tanggal span').html(start.format('YYYY/MM/DD') + ' - ' + end.format('YYYY/MM/DD'));
                startDate = start.format('YYYY/MM/DD');
                endDate = end.format('YYYY/MM/DD');

                //CLEAR DATA
                var table = $('#table').DataTable();
                table.clear().draw();

                //CLEAR CARI
                $('#txt_cari').val('');

                aksi_user(start.format('YYYY/MM/DD'), end.format('YYYY/MM/DD'));
                aksi_statistik(start.format('YYYY/MM/DD'), end.format('YYYY/MM/DD'));
            }
        );
        //Set the initial state of the picker label
        $('#user_tanggal span').html(moment().subtract('days', 29).format('YYYY/MM/DD') + ' - ' + moment().format('YYYY/MM/DD'));

        $('#user_tanggal').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
        });

        //SELECT2
        $('.select2').select2()
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })

    });


    function aksi_user(startDate, endDate) {
        var txt_cari = $("#txt_cari").val();
        $('#table').DataTable({
            "destroy": true,
            "searching": true,
            "processing": true,
            "serverSide": true,
            'scrollX': true,
            'sScrollX': '100%',
            'sScrollY': '500',
            'ordering': false,
            "info": true,
            "paging": true,
            "order": [],
            "ajax": {
                "url": "<?php echo site_url('/user/aksi_user') ?>",
                "type": "POST",
                data: {
                    startDate: startDate,
                    endDate: endDate,
                    txt_cari: txt_cari,
                }
            },
            "dom": "<'row'<'col-sm-12 col-md-12'l><'col-sm-12 col-md-6'B><'col-sm-12 col-md-6'f>>" +
                "<'row'<'.col-md-6:eq(0)'tr>>" +
                "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
            "buttons": ["copy", "print"],

        });
    }

    function aksi_statistik(startDate, endDate) {
        var txt_cari = $("#txt_cari").val();
        document.getElementById("statistik_aktif_jumlah").innerHTML = 'Loading...';
        document.getElementById("statistik_bekukan_jumlah").innerHTML = 'Loading...';
        document.getElementById("statistik_blokir_jumlah").innerHTML = 'Loading...';
        document.getElementById("statistik_semua_jumlah").innerHTML = 'Loading...';

        $.ajax({
            type: 'POST',
            url: '<?php echo base_url() ?>user/aksi_statistik',
            data: {
                startDate: startDate,
                endDate: endDate,
                txt_cari: txt_cari,
            },
            success: function(data) {
                var obj = JSON.parse(data);
                var statistik_aktif_jumlah = obj.statistik_aktif_jumlah;
                var statistik_bekukan_jumlah = obj.statistik_bekukan_jumlah;
                var statistik_blokir_jumlah = obj.statistik_blokir_jumlah;
                var statistik_semua_jumlah = obj.statistik_semua_jumlah;

                document.getElementById("statistik_aktif_jumlah").innerHTML = obj.statistik_aktif_jumlah;
                document.getElementById("statistik_bekukan_jumlah").innerHTML = obj.statistik_bekukan_jumlah;
                document.getElementById("statistik_blokir_jumlah").innerHTML = obj.statistik_blokir_jumlah;
                document.getElementById("statistik_semua_jumlah").innerHTML = obj.statistik_semua_jumlah;
            }
        })
    }

    function aksi_notifikasi_modal(element) {
        $("#modal-notifikasi").modal("show");

        var table = $('#table').DataTable();
        var data_row = table.row($(element).closest('tr')).data();

        var notifikasi_user_kode = data_row[3];

        document.getElementById("notifikasi_user_kode").value = notifikasi_user_kode;
    }

    function aksi_notifikasi_kirim() {
        var notifikasi_user_kode = $("#notifikasi_user_kode").val();
        var notifikasi_judul = $("#notifikasi_judul").val();
        var notifikasi_isi = CKEDITOR.instances['notifikasi_isi'].getData();

        if (notifikasi_judul.length > 5 && notifikasi_isi.length > 10) {
            Swal.fire({
                title: 'Apakah sudah benar?',
                text: "Pastikan notifikasi menggunakan bahasa yang sopan dan sesuai SOP. Jika menekan tombol kirim dibawah, maka pesan akan masuk ke inbox user.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Kirim!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '<?php echo base_url() ?>user/aksi_notifikasi',
                        type: "POST",
                        data: {
                            notifikasi_user_kode: notifikasi_user_kode,
                            notifikasi_judul: notifikasi_judul,
                            notifikasi_isi: notifikasi_isi
                        },
                        success: function(data) {
                            var obj = JSON.parse(data);
                            var notifikasi_status = obj.notifikasi_status;
                            if (notifikasi_status == '0') {
                                toastr.success('Notifikasi berhasil terikirm');
                                $("#modal-notifikasi").modal('hide');

                                //CLEAR DATA
                                $('#notifikasi_judul').val('Transaksi gagal');
                                CKEDITOR.instances['notifikasi_isi'].setData('');
                            } else {
                                toastr.error('Notifikasi gagal terkirim');
                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError, data) {
                            var obj = JSON.parse(data);
                            toastr.error('Notifikasi gagal terkirim');
                        }
                    });

                }
            })
        } else {
            toastr.info('Mohon isi data dengan benar')
        }



    }

    function aksi_aktif($mst_user_kode) {
        Swal.fire({
            title: 'Ganti status user?',
            text: "Status user akan diubah menjadi aktif",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Ya, ubah ke aktif!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>user/aksi_aktif/' + $mst_user_kode,
                    type: "POST",
                    dataType: "html",
                    success: function(data) {
                        var obj = JSON.parse(data);
                        var user_status = obj.user_status;

                        if (user_status == '0') {
                            toastr.success('Berhasil mengubah status');

                            //CLEAR DATA
                            var table = $('#table').DataTable();
                            table.clear().draw();


                            //CLEAR CARI
                            $('#txt_cari').val('');

                            aksi_user(startDate, endDate);
                            aksi_statistik(startDate, endDate);
                        } else {
                            toastr.error('Gagal mengubah status');

                            //CLEAR DATA
                            var table = $('#table').DataTable();
                            table.clear().draw();


                            //CLEAR CARI
                            $('#txt_cari').val('');

                            aksi_user(startDate, endDate);
                            aksi_statistik(startDate, endDate);
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError, data) {
                        var obj = JSON.parse(data);


                        //CLEAR DATA
                        var table = $('#table').DataTable();
                        table.clear().draw();

                        //CLEAR CARI
                        $('#txt_cari').val('');

                        aksi_user(startDate, endDate);
                        aksi_statistik(startDate, endDate);

                        toastr.error('Gagal mengubah status');
                    }
                });

            }
        })
    }

    function aksi_bekukan($mst_user_kode) {
        Swal.fire({
            title: 'Ganti status user?',
            text: "Status user akan diubah menjadi dibekukan",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Ya, ubah ke bekukan!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>user/aksi_bekukan/' + $mst_user_kode,
                    type: "POST",
                    dataType: "html",
                    success: function(data) {
                        var obj = JSON.parse(data);
                        var user_status = obj.user_status;

                        if (user_status == '0') {
                            toastr.success('Berhasil mengubah status');

                            //CLEAR DATA
                            var table = $('#table').DataTable();
                            table.clear().draw();


                            //CLEAR CARI
                            $('#txt_cari').val('');

                            aksi_user(startDate, endDate);
                            aksi_statistik(startDate, endDate);
                        } else {
                            toastr.error('Gagal mengubah status');

                            //CLEAR DATA
                            var table = $('#table').DataTable();
                            table.clear().draw();


                            //CLEAR CARI
                            $('#txt_cari').val('');

                            aksi_user(startDate, endDate);
                            aksi_statistik(startDate, endDate);
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError, data) {
                        var obj = JSON.parse(data);


                        //CLEAR DATA
                        var table = $('#table').DataTable();
                        table.clear().draw();

                        //CLEAR CARI
                        $('#txt_cari').val('');

                        aksi_user(startDate, endDate);
                        aksi_statistik(startDate, endDate);

                        toastr.error('Gagal mengubah status');
                    }
                });

            }
        })
    }

    function aksi_blokir($mst_user_kode) {
        Swal.fire({
            title: 'Ganti status user?',
            text: "Status user akan diubah menjadi diblokir",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Ya, ubah ke blokir!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>user/aksi_blokir/' + $mst_user_kode,
                    type: "POST",
                    dataType: "html",
                    success: function(data) {
                        var obj = JSON.parse(data);
                        var user_status = obj.user_status;

                        if (user_status == '0') {
                            toastr.success('Berhasil mengubah status');

                            //CLEAR DATA
                            var table = $('#table').DataTable();
                            table.clear().draw();


                            //CLEAR CARI
                            $('#txt_cari').val('');

                            aksi_user(startDate, endDate);
                            aksi_statistik(startDate, endDate);
                        } else {
                            toastr.error('Gagal mengubah status');

                            //CLEAR DATA
                            var table = $('#table').DataTable();
                            table.clear().draw();


                            //CLEAR CARI
                            $('#txt_cari').val('');

                            aksi_user(startDate, endDate);
                            aksi_statistik(startDate, endDate);
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError, data) {
                        var obj = JSON.parse(data);


                        //CLEAR DATA
                        var table = $('#table').DataTable();
                        table.clear().draw();

                        //CLEAR CARI
                        $('#txt_cari').val('');

                        aksi_user(startDate, endDate);
                        aksi_statistik(startDate, endDate);

                        toastr.error('Gagal mengubah status');
                    }
                });

            }
        })
    }

    function aksi_hapus($mst_user_kode) {
        Swal.fire({
            title: 'hapus user?',
            text: "Jika sudah menghapus, data tidak bisa dikembalikan lagi.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Ya, hapus!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: '<?php echo base_url() ?>user/aksi_hapus/' + $mst_user_kode,
                    type: "POST",
                    dataType: "html",
                    success: function(data) {
                        var obj = JSON.parse(data);
                        var user_status = obj.user_status;

                        if (user_status == '0') {
                            toastr.success('Berhasil mengubah status');

                            //CLEAR DATA
                            var table = $('#table').DataTable();
                            table.clear().draw();


                            //CLEAR CARI
                            $('#txt_cari').val('');

                            aksi_user(startDate, endDate);
                            aksi_statistik(startDate, endDate);
                        } else {
                            toastr.error('Gagal mengubah status');

                            //CLEAR DATA
                            var table = $('#table').DataTable();
                            table.clear().draw();


                            //CLEAR CARI
                            $('#txt_cari').val('');

                            aksi_user(startDate, endDate);
                            aksi_statistik(startDate, endDate);
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError, data) {
                        var obj = JSON.parse(data);


                        //CLEAR DATA
                        var table = $('#table').DataTable();
                        table.clear().draw();

                        //CLEAR CARI
                        $('#txt_cari').val('');

                        aksi_user(startDate, endDate);
                        aksi_statistik(startDate, endDate);

                        toastr.error('Gagal mengubah status');
                    }
                });

            }
        })
    }
</script>