<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_alfamart_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//ALFAMART
		$trx_alfamart_kode = $this->trx_alfamart_kode();

		//PANGGIL ALFAMART
		$alfamart = $this->db->query("SELECT * FROM tbl_trx_alfamart 
									WHERE 
									trx_alfamart_kode='$trx_alfamart_kode' and 
									trx_alfamart_user_kode='$mst_user_kode'");
		if ($alfamart->num_rows() > 0) {
			foreach ($alfamart->result() as $row) {
				$data['transaksi'][] = array(
					'trx_alfamart_kode' => encrypt($row->trx_alfamart_kode, $this->config->item('key')),
					'trx_alfamart_user_kode' => encrypt($row->trx_alfamart_user_kode, $this->config->item('key')),
					'trx_alfamart_nomor' => encrypt($row->trx_alfamart_nomor, $this->config->item('key')),
					'trx_alfamart_nama' => encrypt($row->trx_alfamart_nama, $this->config->item('key')),
					'trx_alfamart_admin' => encrypt(number_format($row->trx_alfamart_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_alfamart_harga' => encrypt(number_format($row->trx_alfamart_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_alfamart_total' => encrypt(number_format($row->trx_alfamart_admin + $row->trx_alfamart_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_alfamart_poin' => encrypt($row->trx_alfamart_poin, $this->config->item('key')),
					'trx_alfamart_sn' => encrypt($row->trx_alfamart_sn, $this->config->item('key')),
					'trx_alfamart_keterangan' => encrypt($row->trx_alfamart_keterangan, $this->config->item('key')),
					'trx_alfamart_notasi' => encrypt($row->trx_alfamart_notasi, $this->config->item('key')),
					'trx_alfamart_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_alfamart_tanggal)), $this->config->item('key')),
					'trx_alfamart_icon' => encrypt($row->trx_alfamart_icon, $this->config->item('key')),
					'trx_alfamart_rc' => encrypt($row->trx_alfamart_rc, $this->config->item('key')),
					'trx_alfamart_status' => encrypt($row->trx_alfamart_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_alfamart_kode()
	{
		$input = decrypt($this->input->post("trx_alfamart_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
