<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_alfamart_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$alfamart = $this->db->query("SELECT * FROM tbl_mst_alfamart  order by mst_alfamart_urutan asc");

		if ($alfamart->num_rows() > 0) {
			foreach ($alfamart->result() as $row) {
				$data['alfamart'][] = array(
					'mst_alfamart_kode' => encrypt($row->mst_alfamart_kode, $this->config->item('key')),
					'mst_alfamart_nama' => encrypt($row->mst_alfamart_nama, $this->config->item('key')),
					'mst_alfamart_keterangan' => encrypt($row->mst_alfamart_keterangan, $this->config->item('key')),
					'mst_alfamart_notasi' => encrypt($row->mst_alfamart_notasi, $this->config->item('key')),
					'mst_alfamart_harga' => encrypt(number_format($row->mst_alfamart_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_alfamart_admin' => encrypt(number_format($row->mst_alfamart_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_alfamart_total' => encrypt(number_format($row->mst_alfamart_harga + $row->mst_alfamart_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_alfamart_poin' => encrypt($row->mst_alfamart_poin, $this->config->item('key')),
					'mst_alfamart_urutan' => encrypt($row->mst_alfamart_urutan, $this->config->item('key')),
					'mst_alfamart_status' => encrypt($row->mst_alfamart_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
