<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_bonus_activity_transaksi extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
		$this->methods['index_post']['limit_transaksi'] = 1;
	}


	public function index_post()
	{
		date_default_timezone_set($this->mst_user_zona_waktu());

		//USER
		$mst_user_kode = $this->mst_user_kode();

		//TRANSAKSI
		$trx_bonus_kode =  "BONUS-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
		$trx_bonus_tanggal = date('Y-m-d H:i:s');
		$trx_bonus_nama = $this->trx_bonus_nama();
		$trx_bonus_admin = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->trx_bonus_admin());
		$trx_bonus_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->trx_bonus_harga());
		$trx_bonus_total = $trx_bonus_harga + $trx_bonus_admin;
		$trx_bonus_poin = $this->trx_bonus_poin();
		$trx_bonus_keterangan = $this->trx_bonus_keterangan();
		$trx_bonus_notasi = $this->trx_bonus_notasi();
		$trx_bonus_icon = $this->config->item('icon_bonus');

		//KATEGORI TRANSAKSI
		$trx_transaksi_kategori =  $this->config->item('transaksi_bonus');

		//CEK SALDO
		$saldo = $this->db->query("SELECT * FROM tbl_mst_saldo WHERE 
									mst_saldo_user_kode='$mst_user_kode' and 
									mst_saldo_jumlah >= '$trx_bonus_total'");
		if ($saldo->num_rows() > 0) {
			//SALDO CUKUP
			//INSERT KE tbl_trx_bonus
			$this->db->query("insert into tbl_trx_bonus (
				trx_bonus_kode, 
				trx_bonus_user_kode, 
				trx_bonus_nama, 
				trx_bonus_admin,
				trx_bonus_harga,
				trx_bonus_poin,
				trx_bonus_keterangan, 
				trx_bonus_notasi, 
				trx_bonus_tanggal,
				trx_bonus_icon, 
				trx_bonus_rc,
				trx_bonus_status) values (
				'$trx_bonus_kode', 
				'$mst_user_kode', 
				'$trx_bonus_nama', 
				'$trx_bonus_admin',
				'$trx_bonus_harga', 
				'$trx_bonus_poin', 
				'$trx_bonus_keterangan', 
				'$trx_bonus_notasi', 
				'$trx_bonus_tanggal', 
				'$trx_bonus_icon',
				'00',
				'Sukses')");

			//INSERT KE tbl_trx_transaksi
			$this->db->query("insert into tbl_trx_transaksi (
							trx_transaksi_kode, 
							trx_transaksi_user_kode, 
							trx_transaksi_kategori, 
							trx_transaksi_nomor, 
							trx_transaksi_nama, 
							trx_transaksi_jumlah,
							trx_transaksi_keterangan,
							trx_transaksi_notasi, 
							trx_transaksi_tanggal, 
							trx_transaksi_icon, 
							trx_transaksi_rc,
							trx_transaksi_status) values (
							'$trx_bonus_kode', 
							'$mst_user_kode', 
							'$trx_transaksi_kategori', 
							'Bonus',
							'$trx_bonus_nama', 
							'$trx_bonus_total', 
							'$trx_bonus_keterangan',
							'$trx_bonus_notasi',  
							'$trx_bonus_tanggal', 
							'$trx_bonus_icon', 
							'00', 
							'Sukses')");

			//INSERT KE tbl_trx_pendapatan
			$this->db->query("insert into tbl_trx_pendapatan (
								trx_pendapatan_kode, 
								trx_pendapatan_user_kode, 
								trx_pendapatan_kategori, 
								trx_pendapatan_jumlah, 
								trx_pendapatan_tanggal) values (
								'$trx_bonus_kode', 
								'$mst_user_kode', 
								'$trx_transaksi_kategori',
								'$trx_bonus_total', 
								'$trx_bonus_tanggal')");

			//UPDATE tbl_mst_saldo
			$this->db->query("UPDATE tbl_mst_saldo set 
							mst_saldo_jumlah=mst_saldo_jumlah - '$trx_bonus_total'
							where
							mst_saldo_user_kode='$mst_user_kode'");

			//UPDATE tbl_mst_user
			$this->db->query("UPDATE tbl_mst_user set 
							mst_user_tipe='$trx_bonus_nama',
							mst_user_referal_bonus='$trx_bonus_poin'
							where
							mst_user_kode='$mst_user_kode'");

			//PANGGIL BONUS
			$bonus = $this->db->query("SELECT * FROM tbl_trx_bonus 
					WHERE 
					trx_bonus_kode='$trx_bonus_kode' and 
					trx_bonus_user_kode='$mst_user_kode'");
			if ($bonus->num_rows() > 0) {
				foreach ($bonus->result() as $row) {
					$data['transaksi'][] = array(
						'trx_bonus_kode' => encrypt($row->trx_bonus_kode, $this->config->item('key')),
					);
				}

				//BERHASIL
				$sess["status"] = "11";
				$sess["pesan"] = "Transaksi berhasil dan ditemukan";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode($data), $keytoken)
				);
				echo json_encode($sess);
			} else {
				//BERHASIL TAPI GAGAL MEMANGGIL
				$sess["status"] = "22";
				$sess["pesan"] = "Transaksi berhasil dilakukan. Pergi ke riwayat transaksi untuk melihat detail transaksi kamu";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			}

			//BERHASIL
			$sess["status"] = "11";
			$sess["pesan"] = "Transaksi berhasil dan ditemukan. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		} else {
			//SALDO TIDAK CUKUP
			$sess["status"] = "35";
			$sess["pesan"] = "Saldo kamu tidak cukup. Pastikan saldo kamu cukup sebelum melakukan transaksi";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function mst_user_zona_waktu()
	{
		$input = decrypt($this->input->post("mst_user_zona_waktu", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_bonus_nama()
	{
		$input = decrypt($this->input->post("trx_bonus_nama", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_bonus_admin()
	{
		$input = decrypt($this->input->post("trx_bonus_admin", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_bonus_harga()
	{
		$input = decrypt($this->input->post("trx_bonus_harga", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_bonus_poin()
	{
		$input = decrypt($this->input->post("trx_bonus_poin", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_bonus_keterangan()
	{
		$input = decrypt($this->input->post("trx_bonus_keterangan", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_bonus_notasi()
	{
		$input = decrypt($this->input->post("trx_bonus_notasi", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
