<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * @property CI_Input $input
 * @property CI_Config $config
 */
class Api_digiflazz_callback extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper([
            'jwt',
            'authorization',
            'fcm',
            'callback_pulsa',
            'callback_paket_data',
            'callback_paket_nelfon',
            'callback_paket_sms',
            'callback_token_pln',
            'callback_masa_aktif',
            'callback_pulsa_transfer',
            'callback_game',
            'callback_bpjs',
            'callback_hp',
            'callback_tv',
            'callback_pln',
            'callback_internet',
            'callback_multifinance',
            'callback_pdam',
            'callback_pbb',
            'callback_gas',
            'callback_gopay',
            'callback_ovo',
            'callback_linkaja',
            'callback_maxim',
            'callback_dana',
            'callback_shopeepay',
            'callback_doku',
            'callback_grab',
            'callback_sakuku',
            'callback_isaku',
            'callback_gojek_driver',
            'callback_maxim_driver',
            'callback_grab_driver',
            'callback_shopee_driver',
            'callback_indomaret',
            'callback_alfamart',
            'callback_tokopedia',
            'callback_materai',
            'callback_traveloka',
            'callback_mtix',
            'callback_tixid',
            'callback_spotify',
            'callback_googleplay',
            'callback_vidio',
            'callback_unipin',
            'callback_wifiid',
            'callback_bukalapak',
            'callback_emoney',
            'callback_tapcash',
            'callback_brizzi'
        ]);
    }

    public function index()
    {
        $reqHeaders = $this->input->request_headers();
        $xBodyResponse = file_get_contents('php://input');
        $xIncomingCallbackTokenHeader = $reqHeaders['X-Hub-Signature'];
        $xDigiflazzCallback = $this->config->item('digiflazz_callback');
        $xDigiflazzSignature = 'sha1=' . hash_hmac('sha1', $xBodyResponse, $this->config->item('digiflazz_api_secretkey'));

        if ($xIncomingCallbackTokenHeader == $xDigiflazzSignature) {
            $rawRequestInput = file_get_contents('php://input');
            $response = json_decode($rawRequestInput, TRUE)['data'];

            //DIGIFLAZZ
            $ref_id =  $response['ref_id'];
            $rc =  $response['rc'];
            $status =  $response['status'];
            $sn =  $response['sn'];

            //PULSA
            if (strtok($ref_id, "-") == "PULSA") {
                pulsa($ref_id, $rc, $status,  $sn);
            }

            //PAKET DATA
            if (strtok($ref_id, "-") == "PAKETDATA") {
                paket_data($ref_id, $rc, $status,  $sn);
            }

            //PAKET NELFON
            if (strtok($ref_id, "-") == "PAKETNELFON") {
                paket_nelfon($ref_id, $rc, $status,  $sn);
            }

            //PAKET SMS
            if (strtok($ref_id, "-") == "PAKETSMS") {
                paket_sms($ref_id, $rc, $status,  $sn);
            }

            //TOKEN PLN
            if (strtok($ref_id, "-") == "TOKENPLN") {
                token_pln($ref_id, $rc, $status,  $sn);
            }

            //MASA AKTIF
            if (strtok($ref_id, "-") == "MASAAKTIF") {
                masa_aktif($ref_id, $rc, $status,  $sn);
            }

            //PULSA TRANSFER
            if (strtok($ref_id, "-") == "PULSATRANSFER") {
                pulsa_transfer($ref_id, $rc, $status,  $sn);
            }

            //GAME
            if (strtok($ref_id, "-") == "GAME") {
                game($ref_id, $rc, $status,  $sn);
            }

            //BPJS
            if (strtok($ref_id, "-") == "BPJS") {
                bpjs($ref_id, $rc, $status,  $sn);
            }

            //HP
            if (strtok($ref_id, "-") == "HP") {
                hp($ref_id, $rc, $status,  $sn);
            }

            //TV
            if (strtok($ref_id, "-") == "TV") {
                tv($ref_id, $rc, $status,  $sn);
            }

            //PLN
            if (strtok($ref_id, "-") == "PLN") {
                pln($response);
            }

            //INTERNET
            if (strtok($ref_id, "-") == "INTERNET") {
                internet($ref_id, $rc, $status,  $sn);
            }

            //MULTIFINANCE
            if (strtok($ref_id, "-") == "MULTIFINANCE") {
                multifinance($ref_id, $rc, $status,  $sn);
            }

            //PDAM
            if (strtok($ref_id, "-") == "PDAM") {
                pdam($response);
            }

            //PBB
            if (strtok($ref_id, "-") == "PBB") {
                pbb($ref_id, $rc, $status,  $sn);
            }

            //GAS
            if (strtok($ref_id, "-") == "GAS") {
                gas($response);
            }

            //GOPAY
            if (strtok($ref_id, "-") == "GOPAY") {
                gopay($ref_id, $rc, $status,  $sn);
            }

            //OVO
            if (strtok($ref_id, "-") == "OVO") {
                ovo($ref_id, $rc, $status,  $sn);
            }

            //LINKAJA
            if (strtok($ref_id, "-") == "LINKAJA") {
                linkaja($ref_id, $rc, $status,  $sn);
            }

            //MAXIM
            if (strtok($ref_id, "-") == "MAXIM") {
                maxim($ref_id, $rc, $status,  $sn);
            }

            //DANA
            if (strtok($ref_id, "-") == "DANA") {
                dana($ref_id, $rc, $status,  $sn);
            }

            //SHOPEEPAY
            if (strtok($ref_id, "-") == "SHOPEEPAY") {
                shopeepay($ref_id, $rc, $status,  $sn);
            }

            //DOKU
            if (strtok($ref_id, "-") == "DOKU") {
                doku($ref_id, $rc, $status,  $sn);
            }

            //GRAB
            if (strtok($ref_id, "-") == "GRAB") {
                grab($ref_id, $rc, $status,  $sn);
            }

            //SAKUKU
            if (strtok($ref_id, "-") == "SAKUKU") {
                sakuku($ref_id, $rc, $status,  $sn);
            }

            //ISAKU
            if (strtok($ref_id, "-") == "ISAKU") {
                isaku($ref_id, $rc, $status,  $sn);
            }

            //GOJEK DRIVER
            if (strtok($ref_id, "-") == "GOJEKDRIVER") {
                gojek_driver($ref_id, $rc, $status,  $sn);
            }

            //MAXIM DRIVER
            if (strtok($ref_id, "-") == "MAXIMDRIVER") {
                maxim_driver($ref_id, $rc, $status,  $sn);
            }

            //GRAB DRIVER
            if (strtok($ref_id, "-") == "GRABDRIVER") {
                grab_driver($ref_id, $rc, $status,  $sn);
            }

            //SHOPEE DRIVER
            if (strtok($ref_id, "-") == "SHOPEEDRIVER") {
                shopee_driver($ref_id, $rc, $status,  $sn);
            }

            //INDOMARET
            if (strtok($ref_id, "-") == "INDOMARET") {
                indomaret($ref_id, $rc, $status,  $sn);
            }

            //ALFAMART
            if (strtok($ref_id, "-") == "ALFAMART") {
                alfamart($ref_id, $rc, $status,  $sn);
            }

            //TOKOPEDIA
            if (strtok($ref_id, "-") == "TOKOPEDIA") {
                tokopedia($ref_id, $rc, $status,  $sn);
            }

            //MATERAI
            if (strtok($ref_id, "-") == "MATERAI") {
                materai($ref_id, $rc, $status,  $sn);
            }

            //TRAVELOKA
            if (strtok($ref_id, "-") == "TRAVELOKA") {
                traveloka($ref_id, $rc, $status,  $sn);
            }

            //MTIX
            if (strtok($ref_id, "-") == "MTIX") {
                mtix($ref_id, $rc, $status,  $sn);
            }

            //TIX ID
            if (strtok($ref_id, "-") == "TIXID") {
                tixid($ref_id, $rc, $status,  $sn);
            }

            //SPOTIFY
            if (strtok($ref_id, "-") == "SPOTIFY") {
                spotify($ref_id, $rc, $status,  $sn);
            }

            //GOOGLEPLAY
            if (strtok($ref_id, "-") == "GOOGLEPLAY") {
                googleplay($ref_id, $rc, $status,  $sn);
            }

            //VIDIO
            if (strtok($ref_id, "-") == "VIDIO") {
                vidio($ref_id, $rc, $status,  $sn);
            }

            //UNIPIN
            if (strtok($ref_id, "-") == "UNIPIN") {
                unipin($ref_id, $rc, $status,  $sn);
            }

            //WIFI ID
            if (strtok($ref_id, "-") == "WIFIID") {
                wifiid($ref_id, $rc, $status,  $sn);
            }

            //BUKALAPAK
            if (strtok($ref_id, "-") == "BUKALAPAK") {
                bukalapak($ref_id, $rc, $status,  $sn);
            }

            //EMONEY
            if (strtok($ref_id, "-") == "EMONEY") {
                emoney($ref_id, $rc, $status,  $sn);
            }

            //TAPCASH
            if (strtok($ref_id, "-") == "TAPCASH") {
                tapcash($ref_id, $rc, $status,  $sn);
            }

            //BRIZZI
            if (strtok($ref_id, "-") == "BRIZZI") {
                brizzi($ref_id, $rc, $status,  $sn);
            }
        } else {
            $sess["status"] = "400";
            $sess["pesan"] = $this->config->item('error_token');
            $keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));
            $sess['data'] = array(
                'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
                'value' =>  encrypt(json_encode(array()), $keytoken)
            );
            echo json_encode($sess);
        }
    }
}
