<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Api_daftar_activity_cek extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index()
	{
		if ($_SERVER['REQUEST_METHOD'] == 'POST') {
			date_default_timezone_set("Asia/Jakarta");

			//USER
			$mst_user_kode =  "USER-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
			$mst_user_nama_lengkap =  ucwords(strtolower($this->mst_user_nama_lengkap()));
			$mst_user_nomor_hp =  $this->mst_user_nomor_hp();
			$mst_user_email =  strtolower($this->mst_user_email());
			$mst_user_password =  sha1($this->mst_user_password());
			$mst_user_tipe = "Normal";
			$mst_user_referal_kode = explode(" ", str_replace(" ", rand(1, 9), substr(str_shuffle(trim(strtoupper($mst_user_nama_lengkap))), 0, 4)))[0] . substr($mst_user_nomor_hp, -2);
			$mst_user_token =  "TOKEN-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('d-m-Y--H:m:s');
			$mst_user_tanggal_daftar = date('Y-m-d H:i:s');
			$mst_user_status = "0";

			//SALDO
			$mst_saldo_kode =  "SALDO-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');

			//POIN
			$mst_poin_kode =  "POIN-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');

			//CEK USER
			$cek = $this->db->query("SELECT * FROM tbl_mst_user WHERE mst_user_nomor_hp='$mst_user_nomor_hp' or mst_user_email='$mst_user_email'");
			if ($cek->num_rows() > 0) {
				//USER SUDAH ADA
				$sess["status"] = "002";
				$sess["pesan"] = $this->config->item('error_pendaftaran_terdaftar');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			} else {
				//CEK KODE REFERRAL
				$referral = $this->db->query("SELECT * FROM tbl_mst_user WHERE mst_user_referal_kode='$mst_user_referal_kode'");
				if ($referral->num_rows() > 0) {
					$mst_user_referal_kode = explode(" ", str_replace(" ", rand(1, 9), substr(str_shuffle(trim(strtoupper($mst_user_nama_lengkap))), 0, 4)))[0] . rand(1, 9) . substr($mst_user_nomor_hp, -2);
				}

				//INSERT USER BARU
				$this->db->query("insert into tbl_mst_user (
				mst_user_kode,
				mst_user_nama_lengkap, 
				mst_user_nomor_hp,
				mst_user_email, 
				mst_user_password,
				mst_user_tipe,
				mst_user_referal_kode,
				mst_user_referal_bonus,
				mst_user_token,
				mst_user_tanggal_daftar,
				mst_user_status) values (
					'$mst_user_kode', 
					'$mst_user_nama_lengkap', 
					'$mst_user_nomor_hp', 
					'$mst_user_email', 
					'$mst_user_password',
					'$mst_user_tipe',
					'$mst_user_referal_kode',
					'5',
					'$mst_user_token',
					'$mst_user_tanggal_daftar',
					'$mst_user_status')");

				//INSERT SALDO
				$this->db->query("insert into tbl_mst_saldo (
					mst_saldo_kode,
					mst_saldo_user_kode, 
					mst_saldo_jumlah) values (
						'$mst_saldo_kode', 
						'$mst_user_kode', 
						'0')");

				//INSERT POIN
				$this->db->query("insert into tbl_mst_poin (
					mst_poin_kode,
					mst_poin_user_kode, 
					mst_poin_jumlah) values (
						'$mst_poin_kode', 
						'$mst_user_kode', 
						'0')");

				//PANGGIL USER
				$user = $this->db->query("SELECT * FROM tbl_mst_user WHERE mst_user_email='$mst_user_email'");
				if ($user->num_rows() > 0) {
					foreach ($user->result() as $row) {
						$data['user'][] = array(
							'mst_user_kode' => encrypt($row->mst_user_kode, $this->config->item('key')),
							'mst_user_nama_lengkap' => encrypt($row->mst_user_nama_lengkap, $this->config->item('key')),
							'mst_user_nomor_hp' => encrypt($row->mst_user_nomor_hp, $this->config->item('key')),
							'mst_user_email' => encrypt($row->mst_user_email, $this->config->item('key')),
							'mst_user_tipe' => encrypt($row->mst_user_tipe, $this->config->item('key')),
							'mst_user_referal_kode' => encrypt($row->mst_user_referal_kode, $this->config->item('key')),
							'mst_user_referal_bonus' => encrypt($row->mst_user_referal_bonus, $this->config->item('key')),
							'mst_user_token' => encrypt($row->mst_user_token, $this->config->item('key')),
							'mst_user_status' => encrypt($row->mst_user_status, $this->config->item('key')),
						);
					}

					$sess["status"] = "001";
					$sess["pesan"] = $this->config->item('error_pendaftaran_berhasil');
					$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
					$sess['data'] = array(
						'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
						'value' =>  encrypt(json_encode($data), $keytoken)
					);
					echo json_encode($sess);
				} else {
					$sess["status"] = "003";
					$sess["pesan"] = $this->config->item('error_pendaftaran_gagal');
					$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
					$sess['data'] = array(
						'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
						'value' =>  encrypt(json_encode(array()), $keytoken)
					);
					echo json_encode($sess);
				}
			}
		}
	}



	private function mst_user_nama_lengkap()
	{
		$input = decrypt($this->input->post("mst_user_nama_lengkap", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function mst_user_nomor_hp()
	{
		$input = decrypt($this->input->post("mst_user_nomor_hp", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function mst_user_email()
	{
		$input = decrypt($this->input->post("mst_user_email", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function mst_user_password()
	{
		$input = decrypt($this->input->post("mst_user_password", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
