<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_home_activity_banner extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Jakarta");
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		$mst_banner_kategori =  $this->mst_banner_kategori();
		$banner = $this->db->query("SELECT * FROM tbl_mst_banner WHERE mst_banner_status='0' and mst_banner_kategori='$mst_banner_kategori'");
		if ($banner->num_rows() > 0) {
			foreach ($banner->result() as $row) {
				$data['banner'][] = array(
					'mst_banner_id' => encrypt($row->mst_banner_id, $this->config->item('key')),
					'mst_banner_kode' => encrypt($row->mst_banner_kode, $this->config->item('key')),
					'mst_banner_tipe' => encrypt($row->mst_banner_tipe, $this->config->item('key')),
					'mst_banner_video' => encrypt($row->mst_banner_video, $this->config->item('key')),
					'mst_banner_gambar' => encrypt($row->mst_banner_gambar, $this->config->item('key')),
					'mst_banner_judul' => encrypt($row->mst_banner_judul, $this->config->item('key')),
					'mst_banner_isi' => encrypt($row->mst_banner_isi, $this->config->item('key')),
					'mst_banner_link' => encrypt($row->mst_banner_link, $this->config->item('key')),
					'mst_banner_status' => encrypt($row->mst_banner_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Banner tersedia";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Banner tidak ada";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}

	private function mst_banner_kategori()
	{
		$input = decrypt($this->input->post("mst_banner_kategori", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
