<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_main_activity_user extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
		$this->load->helper('hash');
	}


	public function index_post()
	{
		date_default_timezone_set($this->mst_user_zona_waktu());
		$mst_user_kode = $this->mst_user_kode();
		$mst_user_terkhir_aktif = date('Y-m-d H:i:s');
		$mst_user_zona_waktu = $this->mst_user_zona_waktu();

		//UPDATE tbl_mst_user
		$this->db->query("UPDATE tbl_mst_user set 
					mst_user_terkhir_aktif='$mst_user_terkhir_aktif', 
					mst_user_zona_waktu='$mst_user_zona_waktu'
					where
					mst_user_kode='$mst_user_kode'");

		//PANGGIL USER
		$user = $this->db->query("SELECT * FROM tbl_mst_user WHERE mst_user_kode='$mst_user_kode'");
		if ($user->num_rows() > 0) {
			foreach ($user->result() as $row) {
				$mst_user_status = $row->mst_user_status;
				$data['user'][] = array(
					'mst_user_kode' => encrypt($row->mst_user_kode, $this->config->item('key')),
					'mst_user_nama_lengkap' => encrypt($row->mst_user_nama_lengkap, $this->config->item('key')),
					'mst_user_nomor_hp' => encrypt($row->mst_user_nomor_hp, $this->config->item('key')),
					'mst_user_email' => encrypt($row->mst_user_email, $this->config->item('key')),
					'mst_user_tipe' => encrypt($row->mst_user_tipe, $this->config->item('key')),
					'mst_user_referal_kode' => encrypt($row->mst_user_referal_kode, $this->config->item('key')),
					'mst_user_referal_bonus' => encrypt($row->mst_user_referal_bonus, $this->config->item('key')),
					'mst_user_token' => encrypt($row->mst_user_token, $this->config->item('key')),
					'mst_user_zona_waktu' => encrypt($row->mst_user_zona_waktu, $this->config->item('key')),
					'mst_user_status' => encrypt($row->mst_user_status, $this->config->item('key')),
				);
			}

			if ($mst_user_status == "0") {
				$sess["status"] = "001";
				$sess["pesan"] = "Login berhasil";
				$sess["whatsapp_cs"] = $this->config->item('whatsapp_cs');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode($data), $keytoken)
				);
				echo json_encode($sess);
			}

			//AKUN PENDING
			if ($mst_user_status == "1") {
				$sess["status"] = "005";
				$sess["pesan"] = "Akun pending, silahkan hubungi admin untuk menyelesaikan permasalahan kamu!";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			}

			//AKUN DIBLOKIR
			if ($mst_user_status == "2") {
				$sess["status"] = "006";
				$sess["pesan"] = "Akun diblokir, silahkan hubungi admin untuk menyelesaikan permasalahan kamu!";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			}
		} else {
			$sess["status"] = "003";
			$sess["pesan"] = "Login Gagal , silahkan hubungi admin untuk menyelesaikan permasalahan kamu!";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function mst_user_zona_waktu()
	{
		$input = decrypt($this->input->post("mst_user_zona_waktu", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
