<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_maxim_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//MAXIM
		$trx_maxim_kode = $this->trx_maxim_kode();

		//PANGGIL MAXIM
		$maxim = $this->db->query("SELECT * FROM tbl_trx_maxim 
									WHERE 
									trx_maxim_kode='$trx_maxim_kode' and 
									trx_maxim_user_kode='$mst_user_kode'");
		if ($maxim->num_rows() > 0) {
			foreach ($maxim->result() as $row) {
				$data['transaksi'][] = array(
					'trx_maxim_kode' => encrypt($row->trx_maxim_kode, $this->config->item('key')),
					'trx_maxim_user_kode' => encrypt($row->trx_maxim_user_kode, $this->config->item('key')),
					'trx_maxim_nomor' => encrypt($row->trx_maxim_nomor, $this->config->item('key')),
					'trx_maxim_nama' => encrypt($row->trx_maxim_nama, $this->config->item('key')),
					'trx_maxim_admin' => encrypt(number_format($row->trx_maxim_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_maxim_harga' => encrypt(number_format($row->trx_maxim_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_maxim_total' => encrypt(number_format($row->trx_maxim_admin + $row->trx_maxim_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_maxim_poin' => encrypt($row->trx_maxim_poin, $this->config->item('key')),
					'trx_maxim_sn' => encrypt($row->trx_maxim_sn, $this->config->item('key')),
					'trx_maxim_keterangan' => encrypt($row->trx_maxim_keterangan, $this->config->item('key')),
					'trx_maxim_notasi' => encrypt($row->trx_maxim_notasi, $this->config->item('key')),
					'trx_maxim_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_maxim_tanggal)), $this->config->item('key')),
					'trx_maxim_icon' => encrypt($row->trx_maxim_icon, $this->config->item('key')),
					'trx_maxim_rc' => encrypt($row->trx_maxim_rc, $this->config->item('key')),
					'trx_maxim_status' => encrypt($row->trx_maxim_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_maxim_kode()
	{
		$input = decrypt($this->input->post("trx_maxim_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
