<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_pulsa_activity_cek extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		date_default_timezone_set("Asia/Jakarta");
		//USER
		$mst_user_kode = $this->mst_user_kode();

		//PULSA
		$trx_pulsa_kode = $this->trx_pulsa_kode();

		//PANGGIL PULSA
		$pulsa = $this->db->query("SELECT * FROM tbl_trx_pulsa 
									WHERE 
									trx_pulsa_kode='$trx_pulsa_kode' and 
									trx_pulsa_user_kode='$mst_user_kode'");
		if ($pulsa->num_rows() > 0) {
			foreach ($pulsa->result() as $row) {
				$data['transaksi'][] = array(
					'trx_pulsa_kode' => encrypt($row->trx_pulsa_kode, $this->config->item('key')),
					'trx_pulsa_user_kode' => encrypt($row->trx_pulsa_user_kode, $this->config->item('key')),
					'trx_pulsa_operator' => encrypt($row->trx_pulsa_operator, $this->config->item('key')),
					'trx_pulsa_nomor' => encrypt($row->trx_pulsa_nomor, $this->config->item('key')),
					'trx_pulsa_nama' => encrypt($row->trx_pulsa_nama, $this->config->item('key')),
					'trx_pulsa_admin' => encrypt(number_format($row->trx_pulsa_admin, 0, ',', '.'), $this->config->item('key')),
					'trx_pulsa_harga' => encrypt(number_format($row->trx_pulsa_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_pulsa_total' => encrypt(number_format($row->trx_pulsa_admin + $row->trx_pulsa_harga, 0, ',', '.'), $this->config->item('key')),
					'trx_pulsa_poin' => encrypt($row->trx_pulsa_poin, $this->config->item('key')),
					'trx_pulsa_sn' => encrypt($row->trx_pulsa_sn, $this->config->item('key')),
					'trx_pulsa_keterangan' => encrypt($row->trx_pulsa_keterangan, $this->config->item('key')),
					'trx_pulsa_notasi' => encrypt($row->trx_pulsa_notasi, $this->config->item('key')),
					'trx_pulsa_tanggal' => encrypt(date("d M Y H:i", strtotime($row->trx_pulsa_tanggal)), $this->config->item('key')),
					'trx_pulsa_icon' => encrypt($row->trx_pulsa_icon, $this->config->item('key')),
					'trx_pulsa_rc' => encrypt($row->trx_pulsa_rc, $this->config->item('key')),
					'trx_pulsa_status' => encrypt($row->trx_pulsa_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal mengambil data, silahkan refresh halaman secara berkala";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function mst_user_kode()
	{
		$input = decrypt($this->input->post("mst_user_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}


	private function trx_pulsa_kode()
	{
		$input = decrypt($this->input->post("trx_pulsa_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
