<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_tv_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//TV
		$trx_tv_kode =  "TV-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
		$trx_tv_kategori_kode = $this->trx_tv_kategori_kode();
		$trx_tv_kategori_nama = $this->trx_tv_kategori_nama();
		$trx_tv_nomor = $this->trx_tv_nomor();

		//DIGIFLAZZ
		$url = $this->config->item('digiflazz_api_url');
		$header = array(
			'Content-Type: text/plain',
		);
		$params = array(
			'commands' => 'inq-pasca',
			'username' => $this->config->item('digiflazz_api_username'),
			'buyer_sku_code' => $trx_tv_kategori_kode,
			'customer_no' => $trx_tv_nomor,
			'ref_id' => $trx_tv_kode,
			'testing' => $this->config->item('digiflazz_api_testing'),
			'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . $trx_tv_kode)
		);
		$json = json_encode($params);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$result = curl_exec($ch);
		curl_close($ch);
		$response = json_decode($result, true)['data'];

		if (!empty($response['rc'])) {
			//DIGIFLAZZ
			$rc = $response['rc'];
			$message = $response['message'];
			$customer_no = $response['customer_no'];
			$customer_name = ucwords(strtolower($response['customer_name']));
			$admin = $this->config->item('admin_tv');
			$selling_price = $response['selling_price'];
			$total = $admin + $selling_price;
			$desc = $response['desc'];
			$lembar_tagihan = $desc['lembar_tagihan'];
			$detail = $desc['detail'][0];
			$periode = ucwords(strtolower(substr($detail['periode'], 0, 3))) . " 20" . substr($detail['periode'], -2);


			//SUKSES
			if ($rc == "00") {
				$data['tv'][] = array(
					'trx_tv_kode' => encrypt($trx_tv_kode, $this->config->item('key')),
					'trx_tv_kategori_kode' => encrypt($trx_tv_kategori_kode, $this->config->item('key')),
					'trx_tv_kategori_nama' => encrypt($trx_tv_kategori_nama, $this->config->item('key')),
					'trx_tv_nomor' => encrypt($customer_no, $this->config->item('key')),
					'trx_tv_nama' => encrypt($customer_name, $this->config->item('key')),
					'trx_tv_admin' => encrypt(number_format($admin, 0, ',', '.'), $this->config->item('key')),
					'trx_tv_harga' => encrypt(number_format($selling_price, 0, ',', '.'), $this->config->item('key')),
					'trx_tv_total' => encrypt(number_format($total, 0, ',', '.'), $this->config->item('key')),
					'trx_tv_lembar_tagihan' => encrypt($lembar_tagihan, $this->config->item('key')),
					'trx_tv_periode' => encrypt($periode, $this->config->item('key')),
					'trx_tv_keterangan' => encrypt("-", $this->config->item('key')),
					'trx_tv_notasi' => encrypt("-", $this->config->item('key')),
				);

				//BERHASIL
				$sess["status"] = "11";
				$sess["pesan"] = "Transaksi berhasil dan ditemukan";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode($data), $keytoken)
				);
				echo json_encode($sess);
			} else if ($rc == "60") {
				//TAGIHAN BELUM ADA
				$sess["status"] = "22";
				$sess["pesan"] = $rc . " Tagihan belum tersedia untuk " . $trx_tv_nomor . " Mohon dicek lagi secara berkala dan pastikan nomor yang kamu masukkan sudah benar.";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			} else {
				//GAGAL
				$sess["status"] = "33";
				$sess["pesan"] = $rc . " Transaksi gagal. Silahkan laporkan pesan tersebut ke customer service jika ada pertanyaan lebih lanjut.";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			}
		} else {
			//GAGAL
			$sess["status"] = "34";
			$sess["pesan"] = "Transaksi gagal. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function trx_tv_nomor()
	{
		$input = decrypt($this->input->post("trx_tv_nomor", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_tv_kategori_kode()
	{
		$input = decrypt($this->input->post("trx_tv_kategori_kode", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function trx_tv_kategori_nama()
	{
		$input = decrypt($this->input->post("trx_tv_kategori_nama", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				return $data;
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
