<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_unipin_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$unipin = $this->db->query("SELECT * FROM tbl_mst_unipin  order by mst_unipin_urutan asc");

		if ($unipin->num_rows() > 0) {
			foreach ($unipin->result() as $row) {
				$data['unipin'][] = array(
					'mst_unipin_kode' => encrypt($row->mst_unipin_kode, $this->config->item('key')),
					'mst_unipin_nama' => encrypt($row->mst_unipin_nama, $this->config->item('key')),
					'mst_unipin_keterangan' => encrypt($row->mst_unipin_keterangan, $this->config->item('key')),
					'mst_unipin_notasi' => encrypt($row->mst_unipin_notasi, $this->config->item('key')),
					'mst_unipin_harga' => encrypt(number_format($row->mst_unipin_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_unipin_admin' => encrypt(number_format($row->mst_unipin_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_unipin_total' => encrypt(number_format($row->mst_unipin_harga + $row->mst_unipin_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_unipin_poin' => encrypt($row->mst_unipin_poin, $this->config->item('key')),
					'mst_unipin_urutan' => encrypt($row->mst_unipin_urutan, $this->config->item('key')),
					'mst_unipin_status' => encrypt($row->mst_unipin_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
