<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_wifiid_activity_masukkan extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
	}


	public function index_post()
	{
		//PANGGIL DATA
		$wifiid = $this->db->query("SELECT * FROM tbl_mst_wifiid  order by mst_wifiid_urutan asc");

		if ($wifiid->num_rows() > 0) {
			foreach ($wifiid->result() as $row) {
				$data['wifiid'][] = array(
					'mst_wifiid_kode' => encrypt($row->mst_wifiid_kode, $this->config->item('key')),
					'mst_wifiid_nama' => encrypt($row->mst_wifiid_nama, $this->config->item('key')),
					'mst_wifiid_keterangan' => encrypt($row->mst_wifiid_keterangan, $this->config->item('key')),
					'mst_wifiid_notasi' => encrypt($row->mst_wifiid_notasi, $this->config->item('key')),
					'mst_wifiid_harga' => encrypt(number_format($row->mst_wifiid_harga, 0, ',', '.'), $this->config->item('key')),
					'mst_wifiid_admin' => encrypt(number_format($row->mst_wifiid_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_wifiid_total' => encrypt(number_format($row->mst_wifiid_harga + $row->mst_wifiid_admin, 0, ',', '.'), $this->config->item('key')),
					'mst_wifiid_poin' => encrypt($row->mst_wifiid_poin, $this->config->item('key')),
					'mst_wifiid_urutan' => encrypt($row->mst_wifiid_urutan, $this->config->item('key')),
					'mst_wifiid_status' => encrypt($row->mst_wifiid_status, $this->config->item('key')),
				);
			}

			$sess["status"] = "001";
			$sess["pesan"] = "Berhasil";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode($data), $keytoken)
			);
			echo json_encode($sess);
		} else {
			$sess["status"] = "002";
			$sess["pesan"] = "Gagal";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}
}
