<?php
defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/libraries/Format.php';

use Restserver\Libraries\REST_Controller;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

class Api_wifiid_activity_transaksi extends REST_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->helper(['jwt', 'authorization']);
		$this->methods['index_post']['limit_transaksi'] = 1;
	}

	private $str_mst_user_zona_waktu;
	private $str_mst_user_kode;
	private $str_mst_wifiid_kode;
	private $str_trx_wifiid_nomor;
	private $str_trx_wifiid_nama;
	private $str_trx_wifiid_admin;
	private $str_trx_wifiid_harga;
	private $str_trx_wifiid_poin;
	private $str_trx_wifiid_keterangan;
	private $str_trx_wifiid_notasi;

	public function index_post()
	{
		$this->transaksi_wifiid();

		//TIME ZONE
		date_default_timezone_set($this->str_mst_user_zona_waktu);

		//USER
		$mst_user_kode = $this->str_mst_user_kode;

		//wifiid
		$mst_wifiid_kode = $this->str_mst_wifiid_kode;

		//TRANSAKSI
		$trx_wifiid_kode =  "WIFIID-" . strtoupper(substr(sha1(uniqid()), 0, 10)) . "-" . rand(0, 999) . "-" . date('Hms');
		$trx_wifiid_tanggal = date('Y-m-d H:i:s');
		$trx_wifiid_nomor = $this->str_trx_wifiid_nomor;
		$trx_wifiid_nama = $this->str_trx_wifiid_nama;
		$trx_wifiid_admin = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->str_trx_wifiid_admin);
		$trx_wifiid_harga = str_replace(str_split('\\/:*?"<>|,.-+'), "", $this->str_trx_wifiid_harga);
		$trx_wifiid_total = $trx_wifiid_harga + $trx_wifiid_admin;
		$trx_wifiid_poin = $this->str_trx_wifiid_poin;
		$trx_wifiid_keterangan = $this->str_trx_wifiid_keterangan;
		$trx_wifiid_notasi = $this->str_trx_wifiid_notasi;
		$trx_wifiid_icon = $this->config->item('icon_wifiid');

		//KATEGORI TRANSAKSI
		$trx_transaksi_kategori =  $this->config->item('transaksi_wifiid');

		//CEK SALDO
		$saldo = $this->db->query("SELECT * FROM tbl_mst_saldo WHERE 
									mst_saldo_user_kode='$mst_user_kode' and 
									mst_saldo_jumlah >= '$trx_wifiid_total'");
		if ($saldo->num_rows() > 0) {
			//SALDO CUKUP
			//DIGIFLAZZ
			$url = $this->config->item('digiflazz_api_url');
			$header = array(
				'Content-Type: text/plain',
			);
			$params = array(
				'username' => $this->config->item('digiflazz_api_username'),
				'buyer_sku_code' => $mst_wifiid_kode,
				'customer_no' => $trx_wifiid_nomor,
				'ref_id' => $trx_wifiid_kode,
				'testing' => $this->config->item('digiflazz_api_testing'),
				'sign' => md5($this->config->item('digiflazz_api_username') . $this->config->item('digiflazz_api_key') . $trx_wifiid_kode)
			);
			$json = json_encode($params);
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
			curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$result = curl_exec($ch);
			curl_close($ch);
			$response = json_decode($result, true)['data'];

			if (!empty($response['rc'])) {
				//DIGIFLAZZ
				$rc = $response['rc'];
				$status = $response['status'];
				$sn = $response['sn'];

				//TRANSAKSI SUKSES
				if ($rc == "03") {
					//INSERT KE tbl_trx_wifiid
					$this->db->query("insert into tbl_trx_wifiid (
								trx_wifiid_kode, 
								trx_wifiid_user_kode, 
								trx_wifiid_nomor, 
								trx_wifiid_nama, 
								trx_wifiid_admin,
								trx_wifiid_harga,
								trx_wifiid_poin,
								trx_wifiid_sn, 
								trx_wifiid_keterangan, 
								trx_wifiid_notasi, 
								trx_wifiid_tanggal,
								trx_wifiid_icon, 
								trx_wifiid_rc,
								trx_wifiid_status) values (
								'$trx_wifiid_kode', 
								'$mst_user_kode', 
								'$trx_wifiid_nomor', 
								'$trx_wifiid_nama', 
								'$trx_wifiid_admin',
								'$trx_wifiid_harga', 
								'$trx_wifiid_poin', 
								'$sn', 
								'$trx_wifiid_keterangan', 
								'Transaksi masih pending, cek status transaksi secara berkala', 
								'$trx_wifiid_tanggal', 
								'$trx_wifiid_icon',
								'$rc',
								'$status')");

					//INSERT KE tbl_trx_transaksi
					$this->db->query("insert into tbl_trx_transaksi (
								trx_transaksi_kode, 
								trx_transaksi_user_kode, 
								trx_transaksi_kategori, 
								trx_transaksi_nomor, 
								trx_transaksi_nama, 
								trx_transaksi_jumlah,
								trx_transaksi_keterangan,
								trx_transaksi_notasi, 
								trx_transaksi_tanggal, 
								trx_transaksi_icon, 
								trx_transaksi_rc,
								trx_transaksi_status) values (
								'$trx_wifiid_kode', 
								'$mst_user_kode', 
								'$trx_transaksi_kategori', 
								'$trx_wifiid_nomor',
								'$trx_wifiid_nama', 
								'$trx_wifiid_total', 
								'$trx_wifiid_keterangan',
								'Transaksi masih pending, cek status transaksi secara berkala ',  
								'$trx_wifiid_tanggal', 
								'$trx_wifiid_icon', 
								'$rc', 
								'$status')");

					//UPDATE tbl_mst_saldo
					$this->db->query("UPDATE tbl_mst_saldo set 
									mst_saldo_jumlah=mst_saldo_jumlah - '$trx_wifiid_total'
									where
									mst_saldo_user_kode='$mst_user_kode'");

					//PANGGIL wifiid
					$wifiid = $this->db->query("SELECT * FROM tbl_trx_wifiid 
											WHERE 
											trx_wifiid_kode='$trx_wifiid_kode' and 
											trx_wifiid_user_kode='$mst_user_kode'");
					if ($wifiid->num_rows() > 0) {
						foreach ($wifiid->result() as $row) {
							$data['transaksi'][] = array(
								'trx_wifiid_kode' => encrypt($row->trx_wifiid_kode, $this->config->item('key')),
							);
						}

						//BERHASIL
						$sess["status"] = "11";
						$sess["pesan"] = "Transaksi berhasil dan ditemukan. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
						$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
						$sess['data'] = array(
							'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
							'value' =>  encrypt(json_encode($data), $keytoken)
						);
						echo json_encode($sess);
					} else {
						//BERHASIL TAPI GAGAL MEMANGGIL
						$sess["status"] = "22";
						$sess["pesan"] = "Transaksi berhasil dilakukan. Pergi ke riwayat transaksi untuk melihat detail transaksi kamu";
						$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
						$sess['data'] = array(
							'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
							'value' =>  encrypt(json_encode(array()), $keytoken)
						);
						echo json_encode($sess);
					}
				} else {
					//GAGAL
					$sess["status"] = "33";
					$sess["pesan"] = $rc . " Transaksi gagal. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
					$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
					$sess['data'] = array(
						'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
						'value' =>  encrypt(json_encode(array()), $keytoken)
					);
					echo json_encode($sess);
				}
			} else {
				//GAGAL
				$sess["status"] = "34";
				$sess["pesan"] = "Transaksi gagal. Silahkan laporkan pesan error tersebut ke customer service untuk menyelesaikan masalah kamu.";
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
			}
		} else {
			//SALDO TIDAK CUKUP
			$sess["status"] = "35";
			$sess["pesan"] = "Saldo kamu tidak cukup. Pastikan saldo kamu cukup sebelum melakukan transaksi";
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
		}
	}


	private function transaksi_wifiid()
	{

		$input = decrypt($this->input->post("transaksi_wifiid", true), $this->config->item('key'));
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				$array = explode(".....", $data);
				$mst_transaksi = "";
				foreach ($array as $item) {
					$itemArray = explode(":", $item);
					$key = decrypt(trim($itemArray[0]), $this->config->item('key'));
					$value = trim($itemArray[1]);

					//AMBIL KEY TRANSAKSI
					if ($key == 'mst_transaksi') {
						$mst_transaksi = $value;
					}

					//GENERATE POST SELAIN KEY TRANSAKSI
					if ($key != 'mst_transaksi') {
						$this->transaksi_wifiid_request($key, $mst_transaksi, $value);
					}
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}

	private function transaksi_wifiid_request($key, $mst_transaksi, $value)
	{
		$transaksi = decrypt($mst_transaksi, $this->config->item('key'));
		$input = decrypt($value, $transaksi);
		$token = AUTHORIZATION::generateToken($input);
		try {
			$data = AUTHORIZATION::validateToken($token);
			if ($data === false) {
				$sess["status"] = "004";
				$sess["pesan"] = $this->config->item('error_parameter');
				$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
				$sess['data'] = array(
					'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
					'value' =>  encrypt(json_encode(array()), $keytoken)
				);
				echo json_encode($sess);
				exit();
			} else {
				if ($key == 'mst_user_kode') {
					return $this->str_mst_user_kode = $data;
				}

				if ($key == 'mst_user_zona_waktu') {
					return $this->str_mst_user_zona_waktu = $data;
				}

				if ($key == 'mst_wifiid_kode') {
					return $this->str_mst_wifiid_kode = $data;
				}

				if ($key == 'trx_wifiid_nomor') {
					return $this->str_trx_wifiid_nomor = $data;
				}

				if ($key == 'trx_wifiid_nama') {
					return $this->str_trx_wifiid_nama = $data;
				}

				if ($key == 'trx_wifiid_admin') {
					return $this->str_trx_wifiid_admin = $data;
				}

				if ($key == 'trx_wifiid_harga') {
					return $this->str_trx_wifiid_harga = $data;
				}

				if ($key == 'trx_wifiid_poin') {
					return $this->str_trx_wifiid_poin = $data;
				}

				if ($key == 'trx_wifiid_keterangan') {
					return $this->str_trx_wifiid_keterangan = $data;
				}

				if ($key == 'trx_wifiid_notasi') {
					return $this->str_trx_wifiid_notasi = $data;
				}
			}
		} catch (Exception $e) {
			$sess["status"] = "004";
			$sess["pesan"] = $this->config->item('error_parameter');
			$keytoken = strtoupper(substr(sha1(uniqid()), 0, 16));;
			$sess['data'] = array(
				'token' =>  encrypt($keytoken, $this->config->item('keytoken')),
				'value' =>  encrypt(json_encode(array()), $keytoken)
			);
			echo json_encode($sess);
			exit();
		}
	}
}
